/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.RequiresHttp;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.CreateClientForCaller;
import org.jclouds.rest.internal.RestContextImpl;

@ConfiguresRestClient
@RequiresHttp
public class RestClientModule<S, A>
extends AbstractModule {
    protected final Class<A> asyncClientType;
    protected final Class<S> syncClientType;
    protected final Map<Class<?>, Class<?>> delegates;

    public RestClientModule(Class<S> syncClientType, Class<A> asyncClientType, Map<Class<?>, Class<?>> delegates) {
        this.asyncClientType = asyncClientType;
        this.syncClientType = syncClientType;
        this.delegates = delegates;
    }

    public RestClientModule(Class<S> syncClientType, Class<A> asyncClientType) {
        this(syncClientType, asyncClientType, (Map<Class<?>, Class<?>>)ImmutableMap.of(syncClientType, asyncClientType));
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<RestContext>(){}).to(TypeLiteral.get((Type)Types.newParameterizedType(RestContextImpl.class, (Type[])new Type[]{this.syncClientType, this.asyncClientType}))).in(Scopes.SINGLETON);
        this.bind(TypeLiteral.get((Type)Types.newParameterizedType(RestContext.class, (Type[])new Type[]{this.syncClientType, this.asyncClientType}))).to(TypeLiteral.get((Type)Types.newParameterizedType(RestContextImpl.class, (Type[])new Type[]{this.syncClientType, this.asyncClientType}))).in(Scopes.SINGLETON);
        this.bindAsyncClient();
        this.bindClient();
        this.bindErrorHandlers();
        this.bindRetryHandlers();
    }

    protected void bindRetryHandlers() {
    }

    protected void bindErrorHandlers() {
    }

    protected void bindAsyncClient() {
        BinderUtils.bindAsyncClient(this.binder(), this.asyncClientType);
    }

    protected void bindClient() {
        BinderUtils.bindClient(this.binder(), this.syncClientType, this.asyncClientType, this.delegates);
    }

    @Provides
    @Singleton
    @Named(value="sync")
    LoadingCache<ClassMethodArgs, Object> provideSyncDelegateMap(CreateClientForCaller createClientForCaller) {
        createClientForCaller.sync2Async = this.delegates;
        return CacheBuilder.newBuilder().build((CacheLoader)createClientForCaller);
    }
}

