/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import com.google.inject.util.Types;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.TransformingHttpCommand;
import org.jclouds.http.TransformingHttpCommandExecutorService;
import org.jclouds.http.TransformingHttpCommandImpl;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rest.AsyncClientFactory;
import org.jclouds.rest.HttpAsyncClient;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.binders.BindToJsonPayloadWrappedWith;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.internal.AsyncRestClientProxy;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.rest.internal.SeedAnnotationCache;

public class RestModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new SaxParserModule());
        this.install((Module)new GsonModule());
        this.install(new FactoryModuleBuilder().build(BindToJsonPayloadWrappedWith.Factory.class));
        this.bind(IdentityFunction.class).toInstance((Object)IdentityFunction.INSTANCE);
        this.bind(UriBuilder.class).to(UriBuilderImpl.class);
        this.bind(AsyncRestClientProxy.Factory.class).to(Factory.class).in(Scopes.SINGLETON);
        BinderUtils.bindAsyncClient(this.binder(), HttpAsyncClient.class);
        BinderUtils.bindClient(this.binder(), HttpClient.class, HttpAsyncClient.class, ImmutableMap.of(HttpClient.class, HttpAsyncClient.class));
    }

    @Provides
    @Singleton
    protected LoadingCache<Class<?>, Boolean> seedAnnotationCache(SeedAnnotationCache seedAnnotationCache) {
        return CacheBuilder.newBuilder().build((CacheLoader)seedAnnotationCache);
    }

    @Provides
    @Singleton
    @Named(value="async")
    LoadingCache<ClassMethodArgs, Object> provideAsyncDelegateMap(CreateAsyncClientForCaller createAsyncClientForCaller) {
        return CacheBuilder.newBuilder().build((CacheLoader)createAsyncClientForCaller);
    }

    private static class Factory
    implements AsyncRestClientProxy.Factory {
        @Inject
        private TransformingHttpCommandExecutorService executorService;

        private Factory() {
        }

        @Override
        public TransformingHttpCommand<?> create(HttpRequest request, Function<HttpResponse, ?> transformer) {
            return new TransformingHttpCommandImpl(this.executorService, request, transformer);
        }
    }

    static class CreateAsyncClientForCaller
    extends CacheLoader<ClassMethodArgs, Object> {
        private final Injector injector;
        private final AsyncRestClientProxy.Factory factory;

        @Inject
        CreateAsyncClientForCaller(Injector injector, AsyncRestClientProxy.Factory factory) {
            this.injector = injector;
            this.factory = factory;
        }

        public Object load(ClassMethodArgs from) {
            Class<?> clazz = from.getAsyncClass();
            TypeLiteral typeLiteral = TypeLiteral.get(clazz);
            RestAnnotationProcessor util = (RestAnnotationProcessor)this.injector.getInstance(Key.get((TypeLiteral)TypeLiteral.get((Type)Types.newParameterizedType(RestAnnotationProcessor.class, (Type[])new Type[]{clazz}))));
            util.setCaller(from);
            LoadingCache delegateMap = (LoadingCache)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<LoadingCache<ClassMethodArgs, Object>>(){}, (Annotation)Names.named((String)"async")));
            AsyncRestClientProxy proxy = new AsyncRestClientProxy(this.injector, this.factory, util, typeLiteral, (LoadingCache<ClassMethodArgs, Object>)delegateMap);
            this.injector.injectMembers(proxy);
            return AsyncClientFactory.create(clazz, proxy);
        }
    }
}

