/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Throwables2;

@Singleton
public class MapHttp4xxCodesToExceptions
implements Function<Exception, Object> {
    public Object apply(Exception from) {
        HttpResponseException responseException;
        if (from instanceof HttpResponseException && (responseException = (HttpResponseException)from).getResponse() != null) {
            switch (responseException.getResponse().getStatusCode()) {
                case 401: {
                    throw new AuthorizationException(from);
                }
                case 403: {
                    throw new AuthorizationException(from);
                }
                case 404: {
                    throw new ResourceNotFoundException(from);
                }
                case 409: {
                    throw new IllegalStateException(from);
                }
            }
        }
        return Throwables2.propagateOrNull(from);
    }
}

