/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.lifecycle.Closer;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.Utils;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BuildVersion;
import org.jclouds.rest.annotations.Identity;

@Singleton
public class RestContextImpl<S, A>
implements RestContext<S, A> {
    @Resource
    private Logger logger = Logger.NULL;
    private final A asyncApi;
    private final S syncApi;
    private final Closer closer;
    private final URI endpoint;
    private final String identity;
    private final String provider;
    private final String apiVersion;
    private final String buildVersion;
    private final Utils utils;
    private final Map<String, Credentials> credentialStore;
    private final Set<String> iso3166Codes;

    @Inject
    protected RestContextImpl(Closer closer, Map<String, Credentials> credentialStore, Utils utils, Injector injector, TypeLiteral<S> syncApi, TypeLiteral<A> asyncApi, @Provider URI endpoint, @Provider String provider, @Identity String identity, @ApiVersion String apiVersion, @BuildVersion String buildVersion, @Iso3166 Set<String> iso3166Codes) {
        this.credentialStore = credentialStore;
        this.utils = utils;
        this.asyncApi = injector.getInstance(Key.get(asyncApi));
        this.syncApi = injector.getInstance(Key.get(syncApi));
        this.closer = closer;
        this.endpoint = endpoint;
        this.identity = identity;
        this.provider = provider;
        this.apiVersion = apiVersion;
        this.buildVersion = buildVersion;
        this.iso3166Codes = iso3166Codes;
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            this.logger.error(e, "error closing context", new Object[0]);
        }
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public A getAsyncApi() {
        return this.asyncApi;
    }

    @Override
    public S getApi() {
        return this.syncApi;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Utils getUtils() {
        return this.utils();
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getBuildVersion() {
        return this.buildVersion;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.provider, this.endpoint, this.apiVersion, this.buildVersion, this.identity});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestContextImpl that = (RestContextImpl)obj;
        return Objects.equal((Object)this.provider, (Object)that.provider) && Objects.equal((Object)this.endpoint, (Object)that.endpoint) && Objects.equal((Object)this.apiVersion, (Object)that.apiVersion) && Objects.equal((Object)this.buildVersion, (Object)that.buildVersion) && Objects.equal((Object)this.identity, (Object)that.identity);
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("provider", (Object)this.provider).add("endpoint", (Object)this.endpoint).add("apiVersion", (Object)this.apiVersion).add("buildVersion", (Object)this.buildVersion).add("identity", (Object)this.identity).add("iso3166Codes", this.iso3166Codes).toString();
    }

    @Override
    public Map<String, Credentials> getCredentialStore() {
        return this.credentialStore;
    }

    @Override
    public Map<String, Credentials> credentialStore() {
        return this.credentialStore;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getId() {
        return this.provider;
    }

    @Override
    public Set<String> getIso3166Codes() {
        return this.iso3166Codes;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return ImmutableMap.of((Object)"endpoint", (Object)this.endpoint, (Object)"apiVersion", (Object)this.apiVersion, (Object)"buildVersion", (Object)this.buildVersion, (Object)"identity", (Object)this.identity);
    }

    @Override
    public Location getParent() {
        return null;
    }

    @Override
    public LocationScope getScope() {
        return LocationScope.PROVIDER;
    }
}

