/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.Beta;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.DateService;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;
import org.jclouds.rest.HttpAsyncClient;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.Utils;

@Singleton
public class UtilsImpl
implements Utils {
    private final Json json;
    private final HttpClient simpleClient;
    private final HttpAsyncClient simpleAsyncClient;
    private final Crypto encryption;
    private final DateService date;
    private final ExecutorService userExecutor;
    private final ExecutorService ioExecutor;
    private final Logger.LoggerFactory loggerFactory;
    private Injector injector;

    @Inject
    protected UtilsImpl(Injector injector, Json json, HttpClient simpleClient, HttpAsyncClient simpleAsyncClient, Crypto encryption, DateService date, @Named(value="jclouds.user-threads") ExecutorService userThreads, @Named(value="jclouds.io-worker-threads") ExecutorService ioThreads, Logger.LoggerFactory loggerFactory) {
        this.injector = injector;
        this.json = json;
        this.simpleClient = simpleClient;
        this.simpleAsyncClient = simpleAsyncClient;
        this.encryption = encryption;
        this.date = date;
        this.userExecutor = userThreads;
        this.ioExecutor = ioThreads;
        this.loggerFactory = loggerFactory;
    }

    @Override
    public HttpAsyncClient asyncHttp() {
        return this.simpleAsyncClient;
    }

    @Override
    public DateService date() {
        return this.date;
    }

    @Override
    public Crypto crypto() {
        return this.encryption;
    }

    @Override
    public DateService getDateService() {
        return this.date;
    }

    @Override
    public Crypto getCrypto() {
        return this.encryption;
    }

    @Override
    public HttpAsyncClient getHttpAsyncClient() {
        return this.simpleAsyncClient;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.simpleClient;
    }

    @Override
    public HttpClient http() {
        return this.simpleClient;
    }

    @Override
    public ExecutorService getIoExecutor() {
        return this.ioExecutor;
    }

    @Override
    public ExecutorService getUserExecutor() {
        return this.userExecutor;
    }

    @Override
    public ExecutorService ioExecutor() {
        return this.ioExecutor;
    }

    @Override
    public ExecutorService userExecutor() {
        return this.userExecutor;
    }

    @Override
    public Logger.LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public Logger.LoggerFactory loggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public Json getJson() {
        return this.json;
    }

    @Override
    public Json json() {
        return this.json;
    }

    @Override
    @Beta
    public Injector getInjector() {
        return this.injector;
    }

    @Override
    @Beta
    public Injector injector() {
        return this.getInjector();
    }
}

