/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.binding.nmr.interceptors;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.FragmentStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.servicemix.cxf.binding.nmr.NMRFault;
import org.apache.servicemix.cxf.binding.nmr.NMRMessage;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMRFaultInInterceptor
extends AbstractPhaseInterceptor<NMRMessage> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(NMRFaultInInterceptor.class);

    public NMRFaultInInterceptor() {
        super("unmarshal");
        this.addBefore("*");
    }

    public void handleMessage(NMRMessage message) throws Fault {
        XMLStreamReader xsr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        DepthXMLStreamReader reader = new DepthXMLStreamReader(xsr);
        try {
            if (!StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
                throw new Fault(new Message("ILLEGAL_JBIFAULT_FORMAT", BUNDLE, new Object[0]));
            }
            NMRFault fault = new NMRFault(new Message("faultstring", (ResourceBundle)null, new Object[0]));
            if (StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
                Element detail = StaxUtils.read((XMLStreamReader)new FragmentStreamReader((XMLStreamReader)reader)).getDocumentElement();
                fault.setDetail(detail);
            }
            message.setContent(Exception.class, (Object)fault);
        }
        catch (XMLStreamException xse) {
            throw new Fault(new Message("STAX_READ_EXC", BUNDLE, new Object[0]));
        }
    }
}

