/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.ProfileInfo;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToProfileInfoSet;
import org.jclouds.http.HttpResponse;

@Singleton
public class KeyValuesDelimitedByBlankLinesToProfileInfo
implements Function<HttpResponse, ProfileInfo> {
    private final ListOfKeyValuesDelimitedByBlankLinesToProfileInfoSet setParser;

    @Inject
    public KeyValuesDelimitedByBlankLinesToProfileInfo(ListOfKeyValuesDelimitedByBlankLinesToProfileInfoSet setParser) {
        this.setParser = setParser;
    }

    public ProfileInfo apply(HttpResponse response) {
        Set<ProfileInfo> drives = this.setParser.apply(response);
        if (drives.size() == 0) {
            return null;
        }
        return (ProfileInfo)Iterables.get(drives, (int)0);
    }
}

