/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.cache.blobstore;

import java.util.Arrays;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.cache.CacheManager;
import org.jclouds.karaf.cache.Cacheable;
import org.jclouds.karaf.cache.tasks.UpdateCachesTask;

public class BlobCacheManager
extends CacheManager<BlobStore> {
    public void bindService(BlobStore service) {
        this.services.add(service);
        this.scheduledExecutorService.submit(new UpdateCachesTask<BlobStore>(this.cacheables, Arrays.asList(service)));
    }

    public void unbindService(BlobStore service) {
        if (this.services != null) {
            this.services.remove(service);
        }
    }

    public void bindCachable(Cacheable<BlobStore> cacheable) {
        this.cacheables.add(cacheable);
        this.scheduledExecutorService.submit(new UpdateCachesTask(Arrays.asList(cacheable), this.services));
    }

    public void unbindCachable(Cacheable<BlobStore> cacheable) {
        if (this.cacheables != null) {
            this.cacheables.remove(cacheable);
        }
    }
}

