/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.cache.compute;

import java.util.Arrays;
import org.jclouds.compute.ComputeService;
import org.jclouds.karaf.cache.CacheManager;
import org.jclouds.karaf.cache.Cacheable;
import org.jclouds.karaf.cache.tasks.UpdateCachesTask;

public class ComputeCacheManager
extends CacheManager<ComputeService> {
    public void bindService(ComputeService service) {
        this.services.add(service);
        this.scheduledExecutorService.submit(new UpdateCachesTask<ComputeService>(this.cacheables, Arrays.asList(service)));
    }

    public void unbindService(ComputeService service) {
        if (this.services != null) {
            this.services.remove(service);
        }
    }

    public void bindCachable(Cacheable<ComputeService> cacheable) {
        this.cacheables.add(cacheable);
        this.scheduledExecutorService.submit(new UpdateCachesTask(Arrays.asList(cacheable), this.services));
    }

    public void unbindCachable(Cacheable<ComputeService> cacheable) {
        if (this.cacheables != null) {
            this.cacheables.remove(cacheable);
        }
    }
}

