/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.util.Date;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ShutdownableService;
import org.apache.camel.component.quartz.CamelJob;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.component.quartz.QuartzConsumer;
import org.apache.camel.component.quartz.QuartzMessage;
import org.apache.camel.component.quartz.StatefulCamelJob;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzEndpoint
extends DefaultEndpoint
implements ShutdownableService {
    private static final transient Logger LOG = LoggerFactory.getLogger(QuartzEndpoint.class);
    private LoadBalancer loadBalancer;
    private Trigger trigger;
    private JobDetail jobDetail = new JobDetail();
    private volatile boolean started;
    private volatile boolean stateful;

    public QuartzEndpoint(String endpointUri, QuartzComponent component) {
        super(endpointUri, (Component)component);
        this.getJobDetail().setName("quartz-" + this.getId());
    }

    public void addTrigger(Trigger trigger, JobDetail detail) throws SchedulerException {
        if (trigger.getName() == null) {
            trigger.setName(detail.getName());
        }
        if (trigger.getGroup() == null) {
            trigger.setGroup(detail.getGroup());
        }
        if (trigger.getStartTime() == null) {
            trigger.setStartTime(new Date());
        }
        detail.getJobDataMap().put("CamelQuartzEndpoint", this.getEndpointUri());
        detail.getJobDataMap().put("CamelQuartzCamelContextName", this.getCamelContext().getManagementName());
        if (detail.getJobClass() == null) {
            detail.setJobClass(this.isStateful() ? StatefulCamelJob.class : CamelJob.class);
        }
        if (detail.getName() == null) {
            detail.setName(this.getJobName());
        }
        this.getComponent().addJob(detail, trigger);
    }

    public void pauseTrigger(Trigger trigger) throws SchedulerException {
        this.getComponent().pauseJob(trigger);
    }

    public void deleteTrigger(Trigger trigger) throws SchedulerException {
        this.getComponent().deleteJob(trigger.getName(), trigger.getGroup());
    }

    public void onJobExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        boolean run = true;
        LoadBalancer balancer = this.getLoadBalancer();
        if (balancer instanceof ServiceSupport) {
            run = ((ServiceSupport)balancer).isRunAllowed();
        }
        if (!run) {
            LOG.warn("Cannot execute Quartz Job with context: " + jobExecutionContext + " because processor is not started: " + balancer);
            return;
        }
        LOG.debug("Firing Quartz Job with context: {}", (Object)jobExecutionContext);
        Exchange exchange = this.createExchange(jobExecutionContext);
        try {
            balancer.process(exchange);
            if (exchange.getException() != null) {
                throw new JobExecutionException((Throwable)exchange.getException());
            }
        }
        catch (Exception e) {
            LOG.error(CamelExchangeException.createExceptionMessage((String)"Error processing exchange", (Exchange)exchange, (Throwable)e));
            if (e instanceof JobExecutionException) {
                throw (JobExecutionException)e;
            }
            throw new JobExecutionException((Throwable)e);
        }
    }

    public Exchange createExchange(JobExecutionContext jobExecutionContext) {
        Exchange exchange = this.createExchange();
        exchange.setIn((Message)new QuartzMessage(exchange, jobExecutionContext));
        return exchange;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("You cannot send messages to this endpoint");
    }

    public QuartzConsumer createConsumer(Processor processor) throws Exception {
        return new QuartzConsumer(this, processor);
    }

    protected String createEndpointUri() {
        return "quartz://" + this.getTrigger().getGroup() + "/" + this.getTrigger().getName();
    }

    protected String getJobName() {
        return this.getJobDetail().getName();
    }

    public QuartzComponent getComponent() {
        return (QuartzComponent)super.getComponent();
    }

    public boolean isSingleton() {
        return true;
    }

    public LoadBalancer getLoadBalancer() {
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer();
        }
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public synchronized void consumerStarted(QuartzConsumer consumer) throws SchedulerException {
        ObjectHelper.notNull((Object)this.trigger, (String)"trigger");
        LOG.debug("Adding consumer {}", (Object)consumer.getProcessor());
        this.getLoadBalancer().addProcessor(consumer.getProcessor());
        if (!this.started) {
            this.addTrigger(this.getTrigger(), this.getJobDetail());
            this.started = true;
        }
    }

    public synchronized void consumerStopped(QuartzConsumer consumer) throws SchedulerException {
        ObjectHelper.notNull((Object)this.trigger, (String)"trigger");
        if (this.started) {
            this.pauseTrigger(this.getTrigger());
            this.started = false;
        }
        LOG.debug("Removing consumer {}", (Object)consumer.getProcessor());
        this.getLoadBalancer().removeProcessor(consumer.getProcessor());
    }

    protected LoadBalancer createLoadBalancer() {
        return new RoundRobinLoadBalancer();
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.getComponent()), (String)"QuartzComponent", (Object)((Object)this));
        ServiceHelper.startService((Object)this.loadBalancer);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.loadBalancer);
    }

    protected void doShutdown() throws Exception {
        ObjectHelper.notNull((Object)this.trigger, (String)"trigger");
        this.deleteTrigger(this.getTrigger());
    }
}

