/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackRefNode
extends Node {
    private final char type;

    public BackRefNode(ISourcePosition position, int type) {
        super(position, NodeType.BACKREFNODE);
        this.type = (char)type;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitBackRefNode(this);
    }

    public char getType() {
        return this.type;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        switch (this.type) {
            case '&': {
                return RubyRegexp.last_match(backref);
            }
            case '`': {
                return RubyRegexp.match_pre(backref);
            }
            case '\'': {
                return RubyRegexp.match_post(backref);
            }
            case '+': {
                return RubyRegexp.match_last(backref);
            }
        }
        assert (false) : "backref with invalid type";
        return null;
    }
}

