/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private final Node receiverNode;
    private Node argsNode;
    private Node iterNode;
    public CallSite callAdapter;

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode) {
        this(position, receiverNode, name, argsNode, null);
    }

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode, Node iterNode) {
        super(position, NodeType.CALLNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getCallSite(name);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getCallSite(this.callAdapter.methodName);
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        return argsNode;
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "CallNode: " + this.getName();
    }

    /*
     * Loose catch block
     */
    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        if (this.iterNode == null && this.argsNode != null && this.argsNode.nodeId == NodeType.ARRAYNODE) {
            ArrayNode arrayNode = (ArrayNode)this.argsNode;
            switch (arrayNode.size()) {
                case 0: {
                    return this.callAdapter.call(context, receiver);
                }
                case 1: {
                    IRubyObject arg0 = arrayNode.get(0).interpret(runtime, context, self, aBlock);
                    return this.callAdapter.call(context, receiver, arg0);
                }
                case 2: {
                    IRubyObject arg0 = arrayNode.get(0).interpret(runtime, context, self, aBlock);
                    IRubyObject arg1 = arrayNode.get(1).interpret(runtime, context, self, aBlock);
                    return this.callAdapter.call(context, receiver, arg0, arg1);
                }
                case 3: {
                    IRubyObject arg0 = arrayNode.get(0).interpret(runtime, context, self, aBlock);
                    IRubyObject arg1 = arrayNode.get(1).interpret(runtime, context, self, aBlock);
                    IRubyObject arg2 = arrayNode.get(2).interpret(runtime, context, self, aBlock);
                    return this.callAdapter.call(context, receiver, arg0, arg1, arg2);
                }
            }
        }
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, this.argsNode, self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        Block block = ASTInterpreter.getBlock(runtime, context, self, aBlock, this.iterNode);
        if (!block.isGiven()) {
            return this.callAdapter.call(context, receiver, args);
        }
        while (true) {
            try {
                return this.callAdapter.call(context, receiver, args, block);
            }
            catch (JumpException.RetryJump rj) {
                continue;
            }
            break;
        }
        catch (JumpException.BreakJump bj) {
            return (IRubyObject)bj.getValue();
        }
    }

    public Block getBlock(ThreadContext context, IRubyObject self, IterNode iter) {
        assert (iter != null) : "iter is not null";
        iter.getScope().determineModule();
        return InterpretedBlock.newInterpretedClosure(context, iter.getBlockBody(), self);
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, block);
        if (this.argsNode == null) {
            RuntimeHelpers.invoke(context, receiver, this.getName(), new IRubyObject[]{value}, CallType.NORMAL, Block.NULL_BLOCK);
        } else {
            RubyArray args = (RubyArray)this.argsNode.interpret(runtime, context, self, block);
            args.append(value);
            RuntimeHelpers.invoke(context, receiver, this.getName(), args.toJavaArray(), CallType.NORMAL, Block.NULL_BLOCK);
        }
        return runtime.getNil();
    }
}

