/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.shiro.security;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.shiro.security.ShiroSecurityToken;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.AuthorizationPolicy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.crypto.AesCipherService;
import org.apache.shiro.crypto.CipherService;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroSecurityPolicy
implements AuthorizationPolicy {
    private static final transient Logger LOG = LoggerFactory.getLogger(ShiroSecurityPolicy.class);
    private final byte[] bits128 = new byte[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private CipherService cipherService;
    private byte[] passPhrase = this.bits128;
    private SecurityManager securityManager;
    private List<Permission> permissionsList;
    private boolean alwaysReauthenticate = true;

    public ShiroSecurityPolicy() {
        this.cipherService = new AesCipherService();
        this.permissionsList = new ArrayList<Permission>();
    }

    public ShiroSecurityPolicy(String iniResourcePath) {
        this();
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(iniResourcePath);
        this.securityManager = (SecurityManager)factory.getInstance();
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
    }

    public ShiroSecurityPolicy(Ini ini) {
        this();
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(ini);
        this.securityManager = (SecurityManager)factory.getInstance();
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
    }

    public ShiroSecurityPolicy(String iniResourcePath, byte[] passPhrase) {
        this(iniResourcePath);
        this.setPassPhrase(passPhrase);
    }

    public ShiroSecurityPolicy(Ini ini, byte[] passPhrase) {
        this(ini);
        this.setPassPhrase(passPhrase);
    }

    public ShiroSecurityPolicy(String iniResourcePath, byte[] passPhrase, boolean alwaysReauthenticate) {
        this(iniResourcePath, passPhrase);
        this.setAlwaysReauthenticate(alwaysReauthenticate);
    }

    public ShiroSecurityPolicy(Ini ini, byte[] passPhrase, boolean alwaysReauthenticate) {
        this(ini, passPhrase);
        this.setAlwaysReauthenticate(alwaysReauthenticate);
    }

    public ShiroSecurityPolicy(String iniResourcePath, byte[] passPhrase, boolean alwaysReauthenticate, List<Permission> permissionsList) {
        this(iniResourcePath, passPhrase, alwaysReauthenticate);
        this.setPermissionsList(permissionsList);
    }

    public ShiroSecurityPolicy(Ini ini, byte[] passPhrase, boolean alwaysReauthenticate, List<Permission> permissionsList) {
        this(ini, passPhrase, alwaysReauthenticate);
        this.setPermissionsList(permissionsList);
    }

    public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
    }

    public Processor wrap(RouteContext routeContext, final Processor processor) {
        return new AsyncProcessor(){

            public boolean process(Exchange exchange, final AsyncCallback callback) {
                try {
                    this.applySecurityPolicy(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                    callback.done(true);
                    return true;
                }
                AsyncProcessor ap = AsyncProcessorConverterHelper.convert((Processor)processor);
                boolean sync = AsyncProcessorHelper.process((AsyncProcessor)ap, (Exchange)exchange, (AsyncCallback)new AsyncCallback(){

                    public void done(boolean doneSync) {
                        if (doneSync) {
                            return;
                        }
                        callback.done(false);
                    }
                });
                if (!sync) {
                    return false;
                }
                callback.done(true);
                return true;
            }

            public void process(Exchange exchange) throws Exception {
                this.applySecurityPolicy(exchange);
                processor.process(exchange);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void applySecurityPolicy(Exchange exchange) throws Exception {
                ByteSource encryptedToken = (ByteSource)exchange.getIn().getHeader("SHIRO_SECURITY_TOKEN");
                ByteSource decryptedToken = ShiroSecurityPolicy.this.getCipherService().decrypt(encryptedToken.getBytes(), ShiroSecurityPolicy.this.getPassPhrase());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decryptedToken.getBytes());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                ShiroSecurityToken securityToken = (ShiroSecurityToken)objectInputStream.readObject();
                objectInputStream.close();
                byteArrayInputStream.close();
                Subject currentUser = SecurityUtils.getSubject();
                try {
                    ShiroSecurityPolicy.this.authenticateUser(currentUser, securityToken);
                    ShiroSecurityPolicy.this.authorizeUser(currentUser, exchange);
                }
                finally {
                    if (ShiroSecurityPolicy.this.alwaysReauthenticate) {
                        currentUser.logout();
                        currentUser = null;
                    }
                }
            }
        };
    }

    private void authenticateUser(Subject currentUser, ShiroSecurityToken securityToken) {
        if (!currentUser.isAuthenticated()) {
            UsernamePasswordToken token = new UsernamePasswordToken(securityToken.getUsername(), securityToken.getPassword());
            if (this.alwaysReauthenticate) {
                token.setRememberMe(false);
            } else {
                token.setRememberMe(true);
            }
            try {
                currentUser.login((AuthenticationToken)token);
                LOG.debug("Current User {} successfully authenticated", currentUser.getPrincipal());
            }
            catch (UnknownAccountException uae) {
                throw new UnknownAccountException("Authentication Failed. There is no user with username of " + token.getPrincipal(), uae.getCause());
            }
            catch (IncorrectCredentialsException ice) {
                throw new IncorrectCredentialsException("Authentication Failed. Password for account " + token.getPrincipal() + " was incorrect!", ice.getCause());
            }
            catch (LockedAccountException lae) {
                throw new LockedAccountException("Authentication Failed. The account for username " + token.getPrincipal() + " is locked." + "Please contact your administrator to unlock it.", lae.getCause());
            }
            catch (AuthenticationException ae) {
                throw new AuthenticationException("Authentication Failed.", ae.getCause());
            }
        }
    }

    private void authorizeUser(Subject currentUser, Exchange exchange) throws CamelAuthorizationException {
        boolean authorized = false;
        if (!this.permissionsList.isEmpty()) {
            for (Permission permission : this.permissionsList) {
                if (!currentUser.isPermitted(permission)) continue;
                authorized = true;
                break;
            }
        } else {
            LOG.debug("Valid Permissions List not specified for ShiroSecurityPolicy. No authorization checks will be performed for current user");
            authorized = true;
        }
        if (!authorized) {
            throw new CamelAuthorizationException("Authorization Failed. Subject's role set does not have the necessary permissions to perform further processing", exchange);
        }
        LOG.debug("Current User {} is successfully authorized. The exchange will be allowed to proceed", currentUser.getPrincipal());
    }

    public CipherService getCipherService() {
        return this.cipherService;
    }

    public void setCipherService(CipherService cipherService) {
        this.cipherService = cipherService;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public byte[] getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(byte[] passPhrase) {
        this.passPhrase = passPhrase;
    }

    public List<Permission> getPermissionsList() {
        return this.permissionsList;
    }

    public void setPermissionsList(List<Permission> permissionsList) {
        this.permissionsList = permissionsList;
    }

    public boolean isAlwaysReauthenticate() {
        return this.alwaysReauthenticate;
    }

    public void setAlwaysReauthenticate(boolean alwaysReauthenticate) {
        this.alwaysReauthenticate = alwaysReauthenticate;
    }
}

