/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;

public class HazelcastIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<String> {
    private String repositoryName;
    private IMap<String, Object> repo;
    private HazelcastInstance hazelcastInstance;

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance) {
        this(hazelcastInstance, HazelcastIdempotentRepository.class.getSimpleName());
    }

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance, String repositoryName) {
        this.repositoryName = repositoryName;
        this.hazelcastInstance = hazelcastInstance;
    }

    protected void doStart() throws Exception {
        this.repo = this.hazelcastInstance.getMap(this.repositoryName);
    }

    protected void doStop() throws Exception {
    }

    public boolean add(String key) {
        if (this.contains(key)) {
            return false;
        }
        this.repo.put((Object)key, (Object)false);
        return true;
    }

    public boolean confirm(String key) {
        if (this.contains(key)) {
            this.repo.put((Object)key, (Object)true);
            return true;
        }
        return false;
    }

    public boolean contains(String key) {
        return this.repo.containsKey((Object)key);
    }

    public boolean remove(String key) {
        if (this.contains(key)) {
            this.repo.remove((Object)key);
            return true;
        }
        return false;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }
}

