/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.urlhandler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.karaf.utils.blobstore.BlobStoreHelper;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobUrlHandler
extends AbstractURLStreamHandlerService {
    private final Logger logger = LoggerFactory.getLogger(BlobUrlHandler.class);
    private static String SYNTAX = "blob:provider/container/blob";
    private List<BlobStore> blobStores = new LinkedList<BlobStore>();

    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0 || !url.getPath().contains("/")) {
            throw new MalformedURLException("Container / Blob cannot be null or empty. Syntax: " + SYNTAX);
        }
        String[] parts = url.getPath().split("/");
        if (parts.length == 2 && (url.getHost() == null || url.getHost().trim().length() == 0)) {
            throw new MalformedURLException("Provider cannot be null or empty. Syntax: " + SYNTAX);
        }
        this.logger.debug("Blob Protocol URL is: [" + url + "]");
        return new Connection(url);
    }

    public void setBlobStores(List<BlobStore> blobStores) {
        this.blobStores = blobStores;
    }

    public List<BlobStore> getBlobStores() {
        return this.blobStores;
    }

    public class Connection
    extends URLConnection {
        final String providerName;
        final String containerName;
        final String blobName;
        final URL url;

        public Connection(URL url) {
            super(url);
            this.url = url;
            int index = 0;
            String[] parts = url.getPath().split("/");
            this.providerName = url.getHost() == null || url.getHost().trim().length() == 0 ? parts[index++] : url.getHost();
            this.containerName = parts[index++];
            StringBuilder builder = new StringBuilder();
            builder.append(parts[index++]);
            for (int i = index; i < parts.length; ++i) {
                builder.append("/").append(parts[i]);
            }
            this.blobName = builder.toString();
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                String userInfo;
                String[] ui;
                BlobStore blobStore = BlobStoreHelper.getBlobStore(this.providerName, BlobUrlHandler.this.blobStores);
                if (blobStore == null && this.url.getUserInfo() != null && (ui = (userInfo = this.url.getUserInfo()).split(":")) != null && ui.length == 2) {
                    String identity = ui[0];
                    String credential = ui[1];
                    blobStore = BlobStoreHelper.createBlobStore(this.providerName, identity, credential, new LinkedHashSet(), new Properties());
                    BlobUrlHandler.this.blobStores.add(blobStore);
                }
                if (blobStore == null) {
                    throw new IOException("BlobStore service not available for provider " + this.providerName);
                }
                if (!blobStore.containerExists(this.containerName)) {
                    throw new IOException("Container " + this.containerName + " does not exists");
                }
                if (!blobStore.blobExists(this.containerName, this.blobName)) {
                    throw new IOException("Blob " + this.blobName + " does not exists");
                }
                Blob blob = blobStore.getBlob(this.containerName, this.blobName);
                return blob.getPayload().getInput();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error opening blob protocol url").initCause(e);
            }
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            try {
                BlobStore blobStore = BlobStoreHelper.getBlobStore(this.providerName, BlobUrlHandler.this.blobStores);
                if (!blobStore.containerExists(this.containerName)) {
                    blobStore.createContainerInLocation(null, this.containerName);
                }
                PipedOutputStream out = new PipedOutputStream();
                PipedInputStream is = new PipedInputStream(out);
                blobStore.getBlob(this.containerName, this.blobName).setPayload((InputStream)is);
                return out;
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error opening blob protocol url").initCause(e);
            }
        }
    }
}

