/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.nio.charset.Charset;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.AbstractSmppCommand;
import org.apache.camel.component.smpp.Smpp8BitSplitter;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppDefaultSplitter;
import org.apache.camel.component.smpp.SmppSplitter;
import org.apache.camel.component.smpp.SmppUcs2Splitter;
import org.apache.camel.component.smpp.SmppUtils;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.session.SMPPSession;

public abstract class SmppSmCommand
extends AbstractSmppCommand {
    protected Charset charset;

    public SmppSmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
        this.charset = Charset.forName(config.getEncoding());
    }

    protected byte getProvidedAlphabet(Exchange exchange) {
        Message in = exchange.getIn();
        byte alphabet = -1;
        alphabet = in.getHeaders().containsKey("CamelSmppAlphabet") ? (Byte)in.getHeader("CamelSmppAlphabet", Byte.class) : (byte)this.config.getAlphabet();
        return alphabet;
    }

    protected Charset determineCharset(byte providedAlphabet, byte determinedAlphabet) {
        if (providedAlphabet == -1 && determinedAlphabet == Alphabet.ALPHA_UCS2.value()) {
            return Charset.forName("UTF-16BE");
        }
        return this.charset;
    }

    protected Alphabet determineAlphabet(Exchange exchange) {
        byte[] message;
        String body = (String)exchange.getIn().getBody(String.class);
        byte alphabet = this.getProvidedAlphabet(exchange);
        Alphabet alphabetObj = alphabet == -1 ? (SmppUtils.isGsm0338Encodeable(message = body.getBytes(this.charset)) ? Alphabet.ALPHA_DEFAULT : Alphabet.ALPHA_UCS2) : Alphabet.valueOf((byte)alphabet);
        return alphabetObj;
    }

    protected SmppSplitter createSplitter(Exchange exchange) {
        SmppSplitter splitter;
        Alphabet alphabet = this.determineAlphabet(exchange);
        Message in = exchange.getIn();
        String body = (String)in.getBody(String.class);
        switch (alphabet) {
            case ALPHA_8_BIT: {
                splitter = new Smpp8BitSplitter(body.length());
                break;
            }
            case ALPHA_UCS2: {
                splitter = new SmppUcs2Splitter(body.length());
                break;
            }
            default: {
                splitter = new SmppDefaultSplitter(body.length());
            }
        }
        return splitter;
    }
}

