/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.wan;

import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.impl.wan.WanReplicationEndpoint;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class WanNoDelayReplication
implements Runnable,
WanReplicationEndpoint {
    private Node node;
    private String groupName;
    private String password;
    private final LinkedBlockingQueue<String> addressQueue = new LinkedBlockingQueue();
    private final LinkedList<RecordUpdate> failureQ = new LinkedList();
    private final BlockingQueue<RecordUpdate> q = new ArrayBlockingQueue<RecordUpdate>(100000);
    private volatile boolean running = true;

    public void init(Node node, String groupName, String password, String ... targets) {
        this.node = node;
        this.groupName = groupName;
        this.password = password;
        this.addressQueue.addAll(Arrays.asList(targets));
        node.executorManager.executeNow(this);
    }

    public void recordUpdated(Record record) {
        DataRecordEntry dataRecordEntry = new DataRecordEntry(record);
        RecordUpdate ru = new RecordUpdate(dataRecordEntry, record.getName());
        if (!this.q.offer(ru)) {
            this.q.poll();
            this.q.offer(ru);
        }
    }

    public void run() {
        Connection conn = null;
        while (this.running) {
            try {
                RecordUpdate ru;
                RecordUpdate recordUpdate = ru = this.failureQ.size() > 0 ? this.failureQ.removeFirst() : this.q.take();
                if (conn == null) {
                    conn = this.getConnection();
                }
                conn.getWriteHandler().enqueueSocketWritable(ru.toNewPacket());
                if (conn.live()) continue;
                this.failureQ.addFirst(ru);
            }
            catch (InterruptedException e) {
                this.running = false;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    Connection getConnection() throws InterruptedException {
        while (true) {
            String targetStr = this.addressQueue.take();
            Address target = null;
            try {
                target = null;
                int colon = targetStr.indexOf(58);
                target = colon == -1 ? new Address(targetStr, this.node.getConfig().getPort()) : new Address(targetStr.substring(0, colon), Integer.parseInt(targetStr.substring(colon + 1)));
                Connection conn = this.node.getConnectionManager().getOrConnect(target);
                for (int i = 0; i < 10; ++i) {
                    conn = this.node.getConnectionManager().getConnection(target);
                    if (conn != null) {
                        return conn;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable e) {
                Thread.sleep(1000L);
            }
            this.addressQueue.offer(targetStr);
        }
    }

    class RecordUpdate {
        final DataRecordEntry dataRecordEntry;
        final String name;

        RecordUpdate(DataRecordEntry dataRecordEntry, String name) {
            this.dataRecordEntry = dataRecordEntry;
            this.name = name;
        }

        public Packet toNewPacket() {
            Packet packet = new Packet();
            packet.name = this.name;
            packet.operation = ClusterOperation.CONCURRENT_MAP_ASYNC_MERGE;
            packet.setKey(this.dataRecordEntry.getKeyData());
            packet.setValue(IOUtil.toData(this.dataRecordEntry));
            return packet;
        }
    }
}

