/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stax;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.stax.StAXUtil;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.LRUSoftCache;
import org.apache.camel.util.ObjectHelper;

public class StAXJAXBIteratorExpression<T>
extends ExpressionAdapter {
    private static final Map<Class<?>, JAXBContext> JAX_CONTEXTS = new LRUSoftCache(1000);
    private final Class<T> handled;
    private final String handledName;

    public StAXJAXBIteratorExpression(Class<T> handled) {
        ObjectHelper.notNull(handled, (String)"handled");
        this.handled = handled;
        this.handledName = null;
    }

    public StAXJAXBIteratorExpression(String handledName) {
        ObjectHelper.notNull((Object)handledName, (String)"handledName");
        this.handledName = handledName;
        this.handled = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JAXBContext jaxbContext(Class<?> handled) throws JAXBException {
        JAXBContext context;
        if (JAX_CONTEXTS.containsKey(handled)) {
            return JAX_CONTEXTS.get(handled);
        }
        Map<Class<?>, JAXBContext> map = JAX_CONTEXTS;
        synchronized (map) {
            context = JAXBContext.newInstance((Class[])new Class[]{handled});
            JAX_CONTEXTS.put(handled, context);
        }
        return context;
    }

    public Object evaluate(Exchange exchange) {
        try {
            XMLEventReader reader = (XMLEventReader)exchange.getIn().getMandatoryBody(XMLEventReader.class);
            Class clazz = this.handled;
            if (clazz == null && this.handledName != null) {
                clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(this.handledName);
            }
            return this.createIterator(reader, clazz);
        }
        catch (InvalidPayloadException e) {
            exchange.setException((Throwable)e);
            return null;
        }
        catch (JAXBException e) {
            exchange.setException((Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            exchange.setException((Throwable)e);
            return null;
        }
    }

    private Iterator<T> createIterator(XMLEventReader reader, Class<T> clazz) throws JAXBException {
        return new StAXJAXBIterator<T>(clazz, reader);
    }

    static class StAXJAXBIterator<T>
    implements Iterator<T>,
    Closeable {
        private final XMLEventReader reader;
        private final Class<T> clazz;
        private final String name;
        private final Unmarshaller unmarshaller;
        private T element;

        StAXJAXBIterator(Class<T> clazz, XMLEventReader reader) throws JAXBException {
            this.clazz = clazz;
            this.reader = reader;
            this.name = StAXUtil.getTagName(clazz);
            JAXBContext jaxb = StAXJAXBIteratorExpression.jaxbContext(clazz);
            this.unmarshaller = jaxb.createUnmarshaller();
        }

        @Override
        public boolean hasNext() {
            if (this.element == null) {
                this.element = this.getNextElement();
            }
            return this.element != null;
        }

        @Override
        public T next() {
            if (this.element == null) {
                this.element = this.getNextElement();
            }
            T answer = this.element;
            this.element = null;
            return answer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        T getNextElement() {
            Object answer;
            boolean found = false;
            while (!found && this.reader.hasNext()) {
                try {
                    XMLEvent xmlEvent = this.reader.peek();
                    if (xmlEvent != null && xmlEvent.isStartElement() && this.name.equals(xmlEvent.asStartElement().getName().getLocalPart())) {
                        found = true;
                        continue;
                    }
                    this.reader.nextEvent();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
            }
            if (!found) {
                return null;
            }
            try {
                answer = this.unmarshaller.unmarshal(this.reader, this.clazz);
                if (answer != null && answer.getClass() == JAXBElement.class) {
                    JAXBElement jbe = answer;
                    answer = jbe.getValue();
                }
            }
            catch (JAXBException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            return (T)answer;
        }

        @Override
        public void close() throws IOException {
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
    }
}

