/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.handlers;

import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.atmos.domain.AtmosError;
import org.jclouds.atmos.util.AtmosUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.logging.Logger;

public class AtmosClientErrorRetryHandler
implements HttpRetryHandler {
    private final AtmosUtils utils;
    private final BackoffLimitedRetryHandler backoffHandler;
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    private int retryCountLimit = 5;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public AtmosClientErrorRetryHandler(BackoffLimitedRetryHandler backoffHandler, AtmosUtils utils) {
        this.backoffHandler = backoffHandler;
        this.utils = utils;
    }

    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if (command.getFailureCount() > this.retryCountLimit) {
            return false;
        }
        if (response.getStatusCode() == 404 && command.getCurrentRequest().getMethod().equals("DELETE")) {
            command.incrementFailureCount();
            return true;
        }
        if (response.getStatusCode() == 409 || response.getStatusCode() == 400) {
            byte[] content = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
            if (content != null) {
                try {
                    AtmosError error = this.utils.parseAtmosErrorFromContent(command, response, new String(content));
                    if (error.getCode() == 1016) {
                        return this.backoffHandler.shouldRetryRequest(command, response);
                    }
                    command.incrementFailureCount();
                }
                catch (HttpException e) {
                    this.logger.warn((Throwable)e, "error parsing response: %s", new Object[]{new String(content)});
                }
            } else {
                command.incrementFailureCount();
            }
            return true;
        }
        return false;
    }
}

