/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jsmpp.InvalidCommandLengthException;
import org.jsmpp.PDUReader;
import org.jsmpp.bean.Command;
import org.jsmpp.util.OctetUtil;

public class DefaultPDUReader
implements PDUReader {
    public Command readPDUHeader(DataInputStream in) throws InvalidCommandLengthException, IOException {
        Command header = new Command();
        header.setCommandLength(in.readInt());
        if (header.getCommandLength() < 16) {
            byte[] dump = new byte[header.getCommandLength()];
            in.read(dump, 4, header.getCommandLength() - 4);
            throw new InvalidCommandLengthException("Command length " + header.getCommandLength() + " is to short");
        }
        header.setCommandId(in.readInt());
        header.setCommandStatus(in.readInt());
        header.setSequenceNumber(in.readInt());
        return header;
    }

    public byte[] readPDU(InputStream in, Command pduHeader) throws IOException {
        return this.readPDU(in, pduHeader.getCommandLength(), pduHeader.getCommandId(), pduHeader.getCommandStatus(), pduHeader.getSequenceNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPDU(InputStream in, int commandLength, int commandId, int commandStatus, int sequenceNumber) throws IOException {
        byte[] b = new byte[commandLength];
        System.arraycopy(OctetUtil.intToBytes(commandLength), 0, b, 0, 4);
        System.arraycopy(OctetUtil.intToBytes(commandId), 0, b, 4, 4);
        System.arraycopy(OctetUtil.intToBytes(commandStatus), 0, b, 8, 4);
        System.arraycopy(OctetUtil.intToBytes(sequenceNumber), 0, b, 12, 4);
        if (commandLength > 16) {
            int len = commandLength - 16;
            int totalReaded = -1;
            InputStream inputStream = in;
            synchronized (inputStream) {
                totalReaded = in.read(b, 16, commandLength - 16);
            }
            if (totalReaded != len) {
                throw new IOException("Unexpected length of byte readed. Expecting " + len + " but only read " + totalReaded);
            }
        }
        return b;
    }
}

