/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.PropertyConfigurator;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressServer
implements Runnable,
ServerMessageReceiverListener {
    private static final int DEFAULT_MAX_WAIT_BIND = 10;
    private static final String DEFAULT_LOG4J_PATH = "stress/server-log4j.properties";
    private static final Integer DEFAULT_PORT = 8056;
    private static final Integer DEFAULT_PROCESSOR_DEGREE = 3;
    private static final Logger logger = LoggerFactory.getLogger(StressServer.class);
    private final ExecutorService waitBindExecService = Executors.newFixedThreadPool(10);
    private final MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();
    private final AtomicInteger requestCounter = new AtomicInteger();
    private int processorDegree;
    private int port;

    public StressServer(int port, int processorDegree) {
        this.port = port;
        this.processorDegree = processorDegree;
    }

    public void run() {
        try {
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(this.port);
            sessionListener.setSessionStateListener(new SessionStateListenerImpl());
            sessionListener.setPduProcessorDegree(this.processorDegree);
            new TrafficWatcherThread().start();
            logger.info("Listening on port {}", (Object)this.port);
            while (true) {
                SMPPServerSession serverSession = sessionListener.accept();
                logger.info("Accepting connection for session {}", (Object)serverSession.getSessionId());
                serverSession.setMessageReceiverListener(this);
                this.waitBindExecService.execute(new WaitBindTask(serverSession));
            }
        }
        catch (IOException e) {
            logger.error("IO error occured", (Throwable)e);
            return;
        }
    }

    public QuerySmResult onAcceptQuerySm(QuerySm querySm, SMPPServerSession source) throws ProcessRequestException {
        return null;
    }

    public MessageId onAcceptSubmitSm(SubmitSm submitSm, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        logger.debug("Receiving submit_sm {}, and return message id {}", (Object)new String(submitSm.getShortMessage()), (Object)messageId.getValue());
        this.requestCounter.incrementAndGet();
        return messageId;
    }

    public SubmitMultiResult onAcceptSubmitMulti(SubmitMulti submitMulti, SMPPServerSession source) throws ProcessRequestException {
        return null;
    }

    public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
        return null;
    }

    public void onAcceptCancelSm(CancelSm cancelSm, SMPPServerSession source) throws ProcessRequestException {
    }

    public void onAcceptReplaceSm(ReplaceSm replaceSm, SMPPServerSession source) throws ProcessRequestException {
    }

    public static void main(String[] args) {
        int processorDegree;
        int port;
        try {
            port = Integer.parseInt(System.getProperty("jsmpp.server.port", DEFAULT_PORT.toString()));
        }
        catch (NumberFormatException e) {
            port = DEFAULT_PORT;
        }
        try {
            processorDegree = Integer.parseInt(System.getProperty("jsmpp.server.procDegree", DEFAULT_PROCESSOR_DEGREE.toString()));
        }
        catch (NumberFormatException e) {
            processorDegree = DEFAULT_PROCESSOR_DEGREE;
        }
        String log4jPath = System.getProperty("jsmpp.server.log4jPath", DEFAULT_LOG4J_PATH);
        PropertyConfigurator.configure((String)log4jPath);
        logger.info("Processor degree: " + processorDegree);
        StressServer stressServer = new StressServer(port, processorDegree);
        stressServer.run();
    }

    private class DeliveryReceiptTask
    implements Runnable {
        private final SMPPServerSession session;
        private final SubmitSm submitSm;
        private MessageId messageId;

        public DeliveryReceiptTask(SMPPServerSession session, SubmitSm submitSm, MessageId messageId) {
            this.session = session;
            this.submitSm = submitSm;
            this.messageId = messageId;
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            String stringValue = Integer.valueOf(this.messageId.getValue(), 16).toString();
            try {
                DeliveryReceipt delRec = new DeliveryReceipt(stringValue, 1, 1, new Date(), new Date(), DeliveryReceiptState.DELIVRD, null, new String(this.submitSm.getShortMessage()));
                this.session.deliverShortMessage("mc", TypeOfNumber.valueOf(this.submitSm.getDestAddrTon()), NumberingPlanIndicator.valueOf(this.submitSm.getDestAddrNpi()), this.submitSm.getDestAddress(), TypeOfNumber.valueOf(this.submitSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf(this.submitSm.getSourceAddrNpi()), this.submitSm.getSourceAddr(), new ESMClass(MessageMode.DEFAULT, MessageType.SMSC_DEL_RECEIPT, GSMSpecificFeature.DEFAULT), (byte)0, (byte)0, new RegisteredDelivery(0), DataCoding.newInstance(0), delRec.toString().getBytes(), new OptionalParameter[0]);
                logger.debug("Sending delivery reciept for message id " + this.messageId + ":" + stringValue);
            }
            catch (Exception e) {
                logger.error("Failed sending delivery_receipt for message id " + this.messageId + ":" + stringValue, (Throwable)e);
            }
        }
    }

    private class SessionStateListenerImpl
    implements SessionStateListener {
        private SessionStateListenerImpl() {
        }

        public void onStateChange(SessionState newState, SessionState oldState, Object source) {
            SMPPServerSession session = (SMPPServerSession)source;
            logger.info("New state of " + session.getSessionId() + " is " + (Object)((Object)newState));
        }
    }

    private class TrafficWatcherThread
    extends Thread {
        private TrafficWatcherThread() {
        }

        public void run() {
            logger.info("Starting traffic watcher...");
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int trafficPerSecond = StressServer.this.requestCounter.getAndSet(0);
                logger.info("Traffic per second : " + trafficPerSecond);
            }
        }
    }

    private class WaitBindTask
    implements Runnable {
        private final SMPPServerSession serverSession;

        public WaitBindTask(SMPPServerSession serverSession) {
            this.serverSession = serverSession;
        }

        public void run() {
            try {
                BindRequest bindRequest = this.serverSession.waitForBind(1000L);
                logger.debug("Accepting bind for session {}", (Object)this.serverSession.getSessionId());
                try {
                    bindRequest.accept("sys");
                }
                catch (PDUStringException e) {
                    logger.error("Invalid system id", (Throwable)e);
                    bindRequest.reject(8);
                }
            }
            catch (IllegalStateException e) {
                logger.error("System error", (Throwable)e);
            }
            catch (TimeoutException e) {
                logger.warn("Wait for bind has reach timeout", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Failed accepting bind request for session {}", (Object)this.serverSession.getSessionId());
            }
        }
    }
}

