/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.binders;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;

@Singleton
public class BindCreateBackupToXmlPayload
implements MapBinder {
    private final BindToStringPayload binder;

    @Inject
    BindCreateBackupToXmlPayload(BindToStringPayload binder) {
        this.binder = binder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        String sliceId = (String)Preconditions.checkNotNull((Object)postParams.get("slice_id"), (Object)"slice_id");
        String name = (String)Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name");
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><backup>");
        builder.append("<slice-id type=\"integer\">").append(sliceId).append("</slice-id>");
        builder.append("<name>").append(name).append("</name>");
        builder.append("</backup>");
        request = this.binder.bindToRequest(request, (Object)builder.toString());
        request.getPayload().getContentMetadata().setContentType("application/xml");
        return request;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("should use map params");
    }
}

