/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.compute.strategy;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.suppliers.JustProvider;
import org.jclouds.slicehost.SlicehostClient;
import org.jclouds.slicehost.domain.Flavor;
import org.jclouds.slicehost.domain.Image;
import org.jclouds.slicehost.domain.Slice;

@Singleton
public class SlicehostComputeServiceAdapter
implements ComputeServiceAdapter<Slice, Flavor, Image, Location> {
    protected final SlicehostClient client;
    protected final JustProvider locationSupplier;

    @Inject
    protected SlicehostComputeServiceAdapter(SlicehostClient client, JustProvider locationSupplier) {
        this.client = (SlicehostClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.locationSupplier = (JustProvider)Preconditions.checkNotNull((Object)locationSupplier, (Object)"locationSupplier");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Slice> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Slice server = this.client.createSlice(name, Integer.parseInt(template.getImage().getProviderId()), Integer.parseInt(template.getHardware().getProviderId()));
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)server, server.getId() + "", LoginCredentials.builder().password(server.getRootPassword()).build());
    }

    public Iterable<Flavor> listHardwareProfiles() {
        return this.client.listFlavors();
    }

    public Iterable<Image> listImages() {
        return this.client.listImages();
    }

    public Iterable<Slice> listNodes() {
        return this.client.listSlices();
    }

    public Iterable<Location> listLocations() {
        return this.locationSupplier.get();
    }

    public Slice getNode(String id) {
        int serverId = Integer.parseInt(id);
        return this.client.getSlice(serverId);
    }

    public void destroyNode(String id) {
        int serverId = Integer.parseInt(id);
        this.client.destroySlice(serverId);
    }

    public void rebootNode(String id) {
        int sliceId = Integer.parseInt(id);
        this.client.hardRebootSlice(sliceId);
    }

    public void resumeNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }

    public void suspendNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }
}

