/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class Slice {
    private final int id;
    private final String name;
    private final int flavorId;
    @Nullable
    private final Integer imageId;
    @Nullable
    private final Integer backupId;
    private final Status status;
    @Nullable
    private final Integer progress;
    private final float bandwidthIn;
    private final float bandwidthOut;
    private final Set<String> addresses;
    @Nullable
    private final String rootPassword;

    public Slice(int id, String name, int flavorId, @Nullable Integer imageId, @Nullable Integer backupId, Status status, @Nullable Integer progress, float bandwidthIn, float bandwidthOut, Set<String> addresses, @Nullable String rootPassword) {
        this.id = id;
        this.name = name;
        this.flavorId = flavorId;
        this.imageId = imageId;
        this.backupId = backupId;
        this.status = status;
        this.progress = progress;
        this.bandwidthIn = bandwidthIn;
        this.bandwidthOut = bandwidthOut;
        this.addresses = addresses;
        this.rootPassword = rootPassword;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getFlavorId() {
        return this.flavorId;
    }

    public Integer getImageId() {
        return this.imageId;
    }

    public Status getStatus() {
        return this.status;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public float getBandwidthIn() {
        return this.bandwidthIn;
    }

    public float getBandwidthOut() {
        return this.bandwidthOut;
    }

    public Set<String> getAddresses() {
        return this.addresses;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public Integer getBackupId() {
        return this.backupId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addresses == null ? 0 : ((Object)this.addresses).hashCode());
        result = 31 * result + (this.backupId == null ? 0 : this.backupId.hashCode());
        result = 31 * result + Float.floatToIntBits(this.bandwidthIn);
        result = 31 * result + Float.floatToIntBits(this.bandwidthOut);
        result = 31 * result + this.flavorId;
        result = 31 * result + this.id;
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.progress == null ? 0 : this.progress.hashCode());
        result = 31 * result + (this.rootPassword == null ? 0 : this.rootPassword.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slice other = (Slice)obj;
        if (this.addresses == null ? other.addresses != null : !((Object)this.addresses).equals(other.addresses)) {
            return false;
        }
        if (this.backupId == null ? other.backupId != null : !this.backupId.equals(other.backupId)) {
            return false;
        }
        if (Float.floatToIntBits(this.bandwidthIn) != Float.floatToIntBits(other.bandwidthIn)) {
            return false;
        }
        if (Float.floatToIntBits(this.bandwidthOut) != Float.floatToIntBits(other.bandwidthOut)) {
            return false;
        }
        if (this.flavorId != other.flavorId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.progress == null ? other.progress != null : !this.progress.equals(other.progress)) {
            return false;
        }
        if (this.rootPassword == null ? other.rootPassword != null : !this.rootPassword.equals(other.rootPassword)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals((Object)other.status));
    }

    public String toString() {
        return "[id=" + this.id + ", name=" + this.name + ", flavorId=" + this.flavorId + ", imageId=" + this.imageId + ", backupId=" + this.backupId + ", status=" + (Object)((Object)this.status) + ", progress=" + this.progress + ", bandwidthIn=" + this.bandwidthIn + ", bandwidthOut=" + this.bandwidthOut + ", addresses=" + this.addresses + ", rootPassword=" + (this.rootPassword != null) + "]";
    }

    public static enum Status {
        ACTIVE,
        BUILD,
        REBOOT,
        HARD_REBOOT,
        TERMINATED,
        UNRECOGNIZED;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String state) {
            try {
                return Status.valueOf(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

