/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.slicehost.xml.ErrorHandler;
import org.jclouds.util.Strings2;

@Singleton
public class ParseSlicehostErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final Pattern RESOURCE_PATTERN = Pattern.compile("^/v1[^/]*/[0-9]+/([^/]+)/([0-9]+)");
    private final ErrorParser errorParser;

    @Inject
    ParseSlicehostErrorFromHttpResponse(ErrorParser errorParser) {
        this.errorParser = errorParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var3_9;
        HttpResponseException httpResponseException = new HttpResponseException(command, response);
        try {
            String content = response.getStatusCode() != 401 ? this.parseErrorFromContentOrNull(command, response) : null;
            HttpResponseException httpResponseException2 = content != null ? new HttpResponseException(command, response, content) : httpResponseException;
            switch (response.getStatusCode()) {
                case 401: {
                    AuthorizationException authorizationException = new AuthorizationException(httpResponseException2.getMessage(), (Throwable)httpResponseException2);
                    break;
                }
                case 403: 
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                    String path = command.getCurrentRequest().getEndpoint().getPath();
                    Matcher matcher = RESOURCE_PATTERN.matcher(path);
                    String message = matcher.find() ? String.format("%s %s not found", matcher.group(1), matcher.group(2)) : path;
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message);
                    break;
                }
                case 422: {
                    IllegalStateException illegalStateException = new IllegalStateException(content);
                    break;
                }
                default: {
                    HttpResponseException httpResponseException3 = new HttpResponseException(command, response, content);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtils.releasePayload((HttpMessage)response);
            command.setException((Exception)httpResponseException);
            throw throwable;
        }
        HttpUtils.releasePayload((HttpMessage)response);
        command.setException((Exception)var3_9);
    }

    String parseErrorFromContentOrNull(HttpCommand command, HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                String payload = Strings2.toStringAndClose((InputStream)response.getPayload().getInput()).trim();
                return payload.indexOf("xml") != -1 ? this.errorParser.parse(payload) : payload;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Singleton
    static class ErrorParser {
        final ParseSax.Factory factory;
        final Provider<ErrorHandler> errorHandlerProvider;
        @Resource
        protected Logger logger = Logger.NULL;

        @Inject
        ErrorParser(ParseSax.Factory factory, Provider<ErrorHandler> errorHandlerProvider) {
            this.factory = factory;
            this.errorHandlerProvider = errorHandlerProvider;
        }

        String parse(String in) {
            return (String)this.factory.create((ParseSax.HandlerWithResult)this.errorHandlerProvider.get()).parse(in);
        }
    }
}

