/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.slicehost.SlicehostClient;
import org.jclouds.slicehost.domain.Slice;

@Singleton
public class SliceTerminated
implements Predicate<Slice> {
    private final SlicehostClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public SliceTerminated(SlicehostClient client) {
        this.client = client;
    }

    public boolean apply(Slice slice) {
        this.logger.trace("looking for state on slice %s", new Object[]{Preconditions.checkNotNull((Object)slice, (Object)"slice")});
        slice = this.refresh(slice);
        if (slice == null) {
            return true;
        }
        this.logger.trace("%s: looking for slice state %s: currently: %s", new Object[]{slice.getId(), Slice.Status.TERMINATED, slice.getStatus()});
        return slice.getStatus() == Slice.Status.TERMINATED;
    }

    private Slice refresh(Slice slice) {
        return this.client.getSlice(slice.getId());
    }
}

