/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.slicehost.domain.Backup;
import org.jclouds.slicehost.xml.BackupHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BackupsHandler
extends ParseSax.HandlerWithResult<Set<? extends Backup>> {
    private StringBuilder currentText = new StringBuilder();
    private Set<Backup> backups = Sets.newLinkedHashSet();
    private final BackupHandler locationHandler;

    @Inject
    public BackupsHandler(BackupHandler locationHandler) {
        this.locationHandler = locationHandler;
    }

    public Set<? extends Backup> getResult() {
        return this.backups;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.locationHandler.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.locationHandler.endElement(uri, localName, qName);
        if (qName.equals("backup") && this.currentText.toString().trim().equals("")) {
            this.backups.add(this.locationHandler.getResult());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.locationHandler.characters(ch, start, length);
        this.currentText.append(ch, start, length);
    }
}

