/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.slicehost.domain.Image;
import org.jclouds.slicehost.xml.ImageHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImagesHandler
extends ParseSax.HandlerWithResult<Set<? extends Image>> {
    private StringBuilder currentText = new StringBuilder();
    private Set<Image> images = Sets.newLinkedHashSet();
    private final ImageHandler locationHandler;

    @Inject
    public ImagesHandler(ImageHandler locationHandler) {
        this.locationHandler = locationHandler;
    }

    public Set<? extends Image> getResult() {
        return this.images;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.locationHandler.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.locationHandler.endElement(uri, localName, qName);
        if (qName.equals("image") && this.currentText.toString().trim().equals("")) {
            this.images.add(this.locationHandler.getResult());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.locationHandler.characters(ch, start, length);
        this.currentText.append(ch, start, length);
    }
}

