/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.slicehost.domain.Slice;
import org.jclouds.slicehost.xml.SliceHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SlicesHandler
extends ParseSax.HandlerWithResult<Set<? extends Slice>> {
    private StringBuilder currentText = new StringBuilder();
    private Set<Slice> slices = Sets.newLinkedHashSet();
    private final SliceHandler locationHandler;

    @Inject
    public SlicesHandler(SliceHandler locationHandler) {
        this.locationHandler = locationHandler;
    }

    public Set<? extends Slice> getResult() {
        return this.slices;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.locationHandler.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.locationHandler.endElement(uri, localName, qName);
        if (qName.equals("slice") && this.currentText.toString().trim().equals("")) {
            this.slices.add(this.locationHandler.getResult());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.locationHandler.characters(ch, start, length);
        this.currentText.append(ch, start, length);
    }
}

