/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import org.jclouds.PropertiesBuilder;

public class SoftLayerPropertiesBuilder
extends PropertiesBuilder {
    protected Properties defaultProperties() {
        Properties properties = super.defaultProperties();
        properties.setProperty("jclouds.endpoint", "https://api.softlayer.com/rest");
        properties.setProperty("jclouds.api-version", "3");
        properties.setProperty("jclouds.softlayer.virtualguest.order-delay", "3600000");
        properties.setProperty("jclouds.softlayer.virtualguest.package-name", "Cloud Server");
        properties.setProperty("jclouds.softlayer.virtualguest.cpu-regex", "[0-9]+ x ([0-9.]+) GHz Core[s]?");
        properties.setProperty("jclouds.softlayer.virtualguest.disk0-type", "LOCAL");
        properties.setProperty("jclouds.softlayer.virtualguest.port-speed", "10");
        properties.setProperty("jclouds.iso3166-codes", "SG,NL,US-CA,US-TX,US-VA,US-WA,US-TX");
        ImmutableSet.Builder prices = ImmutableSet.builder();
        prices.add((Object)"21");
        prices.add((Object)"55");
        prices.add((Object)"57");
        prices.add((Object)"58");
        prices.add((Object)"1800");
        prices.add((Object)"905");
        prices.add((Object)"418");
        prices.add((Object)"420");
        properties.setProperty("jclouds.softlayer.virtualguest.prices", Joiner.on((char)',').join((Iterable)prices.build()));
        return properties;
    }

    public SoftLayerPropertiesBuilder(Properties properties) {
        super(properties);
    }
}

