/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.location.suppliers.OnlyLocationOrFirstZone;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.softlayer.SoftLayerAsyncClient;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.compute.functions.DatacenterToLocation;
import org.jclouds.softlayer.compute.functions.ProductItemToImage;
import org.jclouds.softlayer.compute.functions.ProductItemsToHardware;
import org.jclouds.softlayer.compute.functions.VirtualGuestToNodeMetadata;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.compute.strategy.SoftLayerComputeServiceAdapter;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.ProductPackage;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.features.AccountClient;
import org.jclouds.softlayer.features.ProductPackageClient;
import org.jclouds.softlayer.predicates.ProductPackagePredicates;

public class SoftLayerComputeServiceContextModule
extends ComputeServiceAdapterContextModule<SoftLayerClient, SoftLayerAsyncClient, VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter> {
    public SoftLayerComputeServiceContextModule() {
        super(SoftLayerClient.class, SoftLayerAsyncClient.class);
    }

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter>>(){}).to(SoftLayerComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VirtualGuest, NodeMetadata>>(){}).to(VirtualGuestToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ProductItem, Image>>(){}).to(ProductItemToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Iterable<ProductItem>, Hardware>>(){}).to(ProductItemsToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Datacenter, Location>>(){}).to(DatacenterToLocation.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Location>>(){}).to(OnlyLocationOrFirstZone.class);
        this.bind(TemplateOptions.class).to(SoftLayerTemplateOptions.class);
    }

    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        return template.osFamily(OsFamily.UBUNTU).osVersionMatches("1[10].[10][04]").os64Bit(true).osDescriptionMatches(".*Minimal Install.*");
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<ProductPackage> getProductPackage(@Named(value="jclouds.session-interval") long seconds, final SoftLayerClient client, final @Named(value="jclouds.softlayer.virtualguest.package-name") String virtualGuestPackageName) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<ProductPackage>(){

            public ProductPackage get() {
                AccountClient accountClient = client.getAccountClient();
                ProductPackageClient productPackageClient = client.getProductPackageClient();
                ProductPackage p = (ProductPackage)Iterables.find(accountClient.getActivePackages(), ProductPackagePredicates.named(virtualGuestPackageName));
                return productPackageClient.getProductPackage(p.getId());
            }
        });
    }

    @Provides
    @Singleton
    public Iterable<ProductItemPrice> prices(@Named(value="jclouds.softlayer.virtualguest.prices") String prices) {
        return Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)Preconditions.checkNotNull((Object)prices, (Object)"prices")), (Function)new Function<String, ProductItemPrice>(){

            public ProductItemPrice apply(String arg0) {
                return ProductItemPrice.builder().id(Integer.parseInt(arg0)).build();
            }
        });
    }
}

