/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemCategory;
import org.jclouds.softlayer.domain.ProductItemPrice;

public class ProductItems {
    public static Function<ProductItem, Float> capacity() {
        return new Function<ProductItem, Float>(){

            public Float apply(ProductItem productItem) {
                return productItem.getCapacity();
            }
        };
    }

    public static Function<ProductItem, String> description() {
        return new Function<ProductItem, String>(){

            public String apply(ProductItem productItem) {
                return productItem.getDescription();
            }
        };
    }

    public static Function<ProductItem, ProductItemPrice> price() {
        return new Function<ProductItem, ProductItemPrice>(){

            public ProductItemPrice apply(ProductItem productItem) {
                if (productItem.getPrices().size() < 1) {
                    throw new NoSuchElementException("ProductItem has no prices:" + productItem);
                }
                return (ProductItemPrice)Iterables.get(productItem.getPrices(), (int)0);
            }
        };
    }

    public static Function<ProductItemPrice, ProductItem> item() {
        return new Function<ProductItemPrice, ProductItem>(){

            public ProductItem apply(ProductItemPrice productItemPrice) {
                Set<ProductItemCategory> categories = productItemPrice.getCategories();
                ProductItem item = productItemPrice.getItem();
                ProductItem.Builder builder = ProductItem.Builder.fromProductItem(productItemPrice.getItem());
                if (item.getCategories().size() == 0 && categories.size() != 0) {
                    builder.categories(categories);
                }
                return builder.build();
            }
        };
    }
}

