/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.options;

import com.google.common.base.Preconditions;
import com.google.common.net.InternetDomainName;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.io.Payload;

public class SoftLayerTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected String domainName = "jclouds.org";
    public static final SoftLayerTemplateOptions NONE = new SoftLayerTemplateOptions();

    public SoftLayerTemplateOptions clone() {
        SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof SoftLayerTemplateOptions) {
            SoftLayerTemplateOptions eTo = (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(to);
            eTo.domainName(this.domainName);
        }
    }

    public TemplateOptions domainName(String domainName) {
        Preconditions.checkNotNull((Object)domainName, (Object)"domainName was null");
        Preconditions.checkArgument((boolean)InternetDomainName.from((String)domainName).hasPublicSuffix(), (String)"domainName %s has no public suffix", (Object[])new Object[]{domainName});
        this.domainName = domainName;
        return this;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public SoftLayerTemplateOptions blockOnPort(int port, int seconds) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public SoftLayerTemplateOptions inboundPorts(int ... ports) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public SoftLayerTemplateOptions authorizePublicKey(String publicKey) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public SoftLayerTemplateOptions installPrivateKey(String privateKey) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Deprecated
    public SoftLayerTemplateOptions runScript(Payload script) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.runScript(script));
    }

    public SoftLayerTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public SoftLayerTemplateOptions userMetadata(String key, String value) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public static class Builder {
        public static SoftLayerTemplateOptions domainName(String domainName) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.domainName(domainName));
        }

        public static SoftLayerTemplateOptions inboundPorts(int ... ports) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static SoftLayerTemplateOptions blockOnPort(int port, int seconds) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static SoftLayerTemplateOptions runScript(Payload script) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.runScript(script));
        }

        public static SoftLayerTemplateOptions userMetadata(Map<String, String> userMetadata) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static SoftLayerTemplateOptions userMetadata(String key, String value) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.userMetadata(key, value));
        }
    }
}

