/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.config;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.util.Map;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.softlayer.SoftLayerAsyncClient;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.config.SoftLayerParserModule;
import org.jclouds.softlayer.features.AccountAsyncClient;
import org.jclouds.softlayer.features.AccountClient;
import org.jclouds.softlayer.features.DatacenterAsyncClient;
import org.jclouds.softlayer.features.DatacenterClient;
import org.jclouds.softlayer.features.ProductPackageAsyncClient;
import org.jclouds.softlayer.features.ProductPackageClient;
import org.jclouds.softlayer.features.VirtualGuestAsyncClient;
import org.jclouds.softlayer.features.VirtualGuestClient;
import org.jclouds.softlayer.handlers.SoftLayerErrorHandler;

@RequiresHttp
@ConfiguresRestClient
public class SoftLayerRestClientModule
extends RestClientModule<SoftLayerClient, SoftLayerAsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(VirtualGuestClient.class, VirtualGuestAsyncClient.class).put(DatacenterClient.class, DatacenterAsyncClient.class).put(ProductPackageClient.class, ProductPackageAsyncClient.class).put(AccountClient.class, AccountAsyncClient.class).build();

    public SoftLayerRestClientModule() {
        super(SoftLayerClient.class, SoftLayerAsyncClient.class, DELEGATE_MAP);
    }

    protected void configure() {
        this.install((Module)new SoftLayerParserModule());
        super.configure();
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(SoftLayerErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(SoftLayerErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(SoftLayerErrorHandler.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(BackoffLimitedRetryHandler.class);
    }
}

