/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.softlayer.domain.Password;

public class OperatingSystem
implements Comparable<OperatingSystem> {
    private int id = -1;
    private Set<Password> passwords = Sets.newLinkedHashSet();

    public static Builder builder() {
        return new Builder();
    }

    OperatingSystem() {
    }

    public OperatingSystem(int id, Iterable<Password> passwords) {
        this.id = id;
        this.passwords = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(passwords, (Object)"passwords")));
    }

    @Override
    public int compareTo(OperatingSystem arg0) {
        return new Integer(this.id).compareTo(arg0.getId());
    }

    public int getId() {
        return this.id;
    }

    public Set<Password> getPasswords() {
        return this.passwords;
    }

    public Builder toBuilder() {
        return Builder.fromOperatingSystem(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "[id=" + this.id + ", passwords=" + this.passwords + "]";
    }

    public static class Builder {
        private int id = -1;
        private Set<Password> passwords = Sets.newLinkedHashSet();

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder password(Password password) {
            this.passwords.add((Password)Preconditions.checkNotNull((Object)password, (Object)"password"));
            return this;
        }

        public Builder passwords(Iterable<Password> passwords) {
            this.passwords = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(passwords, (Object)"passwords")));
            return this;
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.id, this.passwords);
        }

        public static Builder fromOperatingSystem(OperatingSystem in) {
            return OperatingSystem.builder().id(in.getId()).passwords(in.getPasswords());
        }
    }
}

