/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class Password
implements Comparable<Password> {
    private int id = -1;
    private String username;
    private String password;

    public static Builder builder() {
        return new Builder();
    }

    Password() {
    }

    public Password(int id, String username, String password) {
        this.id = id;
        this.username = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)username), (Object)("username cannot be null or empty:" + username));
        this.password = password;
    }

    @Override
    public int compareTo(Password arg0) {
        return new Integer(this.id).compareTo(arg0.getId());
    }

    public int getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Builder toBuilder() {
        return Builder.fromPassword(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Password other = (Password)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "Password [id=" + this.id + ", username=" + this.username + ", password=**********]";
    }

    public static class Builder {
        private int id = -1;
        private String username;
        private String password;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Password build() {
            return new Password(this.id, this.username, this.password);
        }

        public static Builder fromPassword(Password in) {
            return Password.builder().id(in.getId()).username(in.getUsername()).password(in.getPassword());
        }
    }
}

