/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

public class ProductItemCategory
implements Comparable<ProductItemCategory> {
    private int id = -1;
    private String name;
    private String categoryCode;

    public static Builder builder() {
        return new Builder();
    }

    ProductItemCategory() {
    }

    public ProductItemCategory(int id, String name, String categoryCode) {
        this.id = id;
        this.name = name;
        this.categoryCode = categoryCode;
    }

    @Override
    public int compareTo(ProductItemCategory arg0) {
        return new Integer(this.id).compareTo(arg0.getId());
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public Builder toBuilder() {
        return Builder.fromProductItemCategory(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductItemCategory other = (ProductItemCategory)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "ProductItemCategory [id=" + this.id + ", name=" + this.name + ", categoryCode=" + this.categoryCode + "]";
    }

    public static class Builder {
        private int id = -1;
        private String name;
        private String categoryCode;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public ProductItemCategory build() {
            return new ProductItemCategory(this.id, this.name, this.categoryCode);
        }

        public static Builder fromProductItemCategory(ProductItemCategory in) {
            return ProductItemCategory.builder().id(in.getId()).name(in.getName()).categoryCode(in.getCategoryCode());
        }
    }
}

