/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemCategory;

public class ProductItemPrice
implements Comparable<ProductItemPrice> {
    private int id = -1;
    private long itemId = -1L;
    private Float recurringFee;
    private Float hourlyRecurringFee;
    private ProductItem item;
    private Set<ProductItemCategory> categories = Sets.newLinkedHashSet();

    public static Builder builder() {
        return new Builder();
    }

    ProductItemPrice() {
    }

    public ProductItemPrice(int id, long itemId, Float recurringFee, Float hourlyRecurringFee, ProductItem item, Iterable<ProductItemCategory> categories) {
        this.id = id;
        this.itemId = itemId;
        this.recurringFee = recurringFee;
        this.hourlyRecurringFee = hourlyRecurringFee;
        this.item = item;
        this.categories = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(categories, (Object)"categories")));
    }

    @Override
    public int compareTo(ProductItemPrice arg0) {
        return new Integer(this.id).compareTo(arg0.getId());
    }

    public int getId() {
        return this.id;
    }

    public long getItemId() {
        return this.itemId;
    }

    @Nullable
    public Float getRecurringFee() {
        return this.recurringFee;
    }

    @Nullable
    public Float getHourlyRecurringFee() {
        return this.hourlyRecurringFee;
    }

    public Set<ProductItemCategory> getCategories() {
        return this.categories;
    }

    public ProductItem getItem() {
        return this.item;
    }

    public Builder toBuilder() {
        return Builder.fromPrice(this);
    }

    public String toString() {
        return "[id=" + this.id + ", itemId=" + this.itemId + ", recurringFee=" + this.recurringFee + ", hourlyRecurringFee=" + this.hourlyRecurringFee + ", item=" + this.item + ", categories=" + this.categories + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductItemPrice that = (ProductItemPrice)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id ^ this.id >>> 32;
    }

    public static class Builder {
        private int id = -1;
        private long itemId = -1L;
        private Float recurringFee;
        private Float hourlyRecurringFee;
        private ProductItem item;
        private Set<ProductItemCategory> categories = Sets.newLinkedHashSet();

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder itemId(long itemId) {
            this.itemId = itemId;
            return this;
        }

        public Builder recurringFee(Float recurringFee) {
            this.recurringFee = recurringFee;
            return this;
        }

        public Builder hourlyRecurringFee(Float hourlyRecurringFee) {
            this.hourlyRecurringFee = hourlyRecurringFee;
            return this;
        }

        public Builder item(ProductItem item) {
            this.item = item;
            return this;
        }

        public Builder category(ProductItemCategory categories) {
            this.categories.add((ProductItemCategory)Preconditions.checkNotNull((Object)categories, (Object)"categories"));
            return this;
        }

        public Builder categories(Iterable<ProductItemCategory> categories) {
            this.categories = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(categories, (Object)"categories")));
            return this;
        }

        public ProductItemPrice build() {
            return new ProductItemPrice(this.id, this.itemId, this.recurringFee, this.hourlyRecurringFee, this.item, this.categories);
        }

        public static Builder fromPrice(ProductItemPrice in) {
            return ProductItemPrice.builder().id(in.getId()).itemId(in.getItemId()).hourlyRecurringFee(in.getHourlyRecurringFee()).recurringFee(in.getRecurringFee());
        }
    }
}

