/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.VirtualGuest;

public class ProductOrder {
    private int packageId = -1;
    private String location;
    private Set<ProductItemPrice> prices = Sets.newLinkedHashSet();
    private Set<VirtualGuest> virtualGuests = Sets.newLinkedHashSet();
    private int quantity;
    private boolean useHourlyPricing;

    public static Builder builder() {
        return new Builder();
    }

    ProductOrder() {
    }

    public ProductOrder(int packageId, String location, Iterable<ProductItemPrice> prices, Iterable<VirtualGuest> virtualGuest, int quantity, boolean useHourlyPricing) {
        this.packageId = packageId;
        this.location = location;
        this.prices = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(prices, (Object)"prices")));
        this.virtualGuests = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(virtualGuest, (Object)"virtualGuest")));
        this.quantity = quantity;
        this.useHourlyPricing = useHourlyPricing;
    }

    public int getPackageId() {
        return this.packageId;
    }

    public String getLocation() {
        return this.location;
    }

    public Set<ProductItemPrice> getPrices() {
        return this.prices;
    }

    public Set<VirtualGuest> getVirtualGuests() {
        return this.virtualGuests;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean getUseHourlyPricing() {
        return this.useHourlyPricing;
    }

    public Builder toBuilder() {
        return Builder.fromProductOrder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductOrder that = (ProductOrder)o;
        if (this.packageId != that.packageId) {
            return false;
        }
        if (this.quantity != that.quantity) {
            return false;
        }
        if (this.useHourlyPricing != that.useHourlyPricing) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (this.prices != null ? !((Object)this.prices).equals(that.prices) : that.prices != null) {
            return false;
        }
        return !(this.virtualGuests != null ? !((Object)this.virtualGuests).equals(that.virtualGuests) : that.virtualGuests != null);
    }

    public int hashCode() {
        int result = this.packageId ^ this.packageId >>> 32;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.prices != null ? ((Object)this.prices).hashCode() : 0);
        result = 31 * result + (this.virtualGuests != null ? ((Object)this.virtualGuests).hashCode() : 0);
        result = 31 * result + (this.quantity ^ this.quantity >>> 32);
        result = 31 * result + (this.useHourlyPricing ? 1 : 0);
        return result;
    }

    public String toString() {
        return "[packageId=" + this.packageId + ", location=" + this.location + ", prices=" + this.prices + ", virtualGuests=" + this.virtualGuests + ", quantity=" + this.quantity + ", useHourlyPricing=" + this.useHourlyPricing + "]";
    }

    public static class Builder {
        private int packageId = -1;
        private Set<ProductItemPrice> prices = Sets.newLinkedHashSet();
        private Set<VirtualGuest> virtualGuests = Sets.newLinkedHashSet();
        private String location;
        private int quantity;
        private boolean useHourlyPricing;

        public Builder packageId(int packageId) {
            this.packageId = packageId;
            return this;
        }

        public Builder price(ProductItemPrice prices) {
            this.prices.add((ProductItemPrice)Preconditions.checkNotNull((Object)prices, (Object)"prices"));
            return this;
        }

        public Builder prices(Iterable<ProductItemPrice> prices) {
            this.prices = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(prices, (Object)"prices")));
            return this;
        }

        public Builder virtualGuest(VirtualGuest virtualGuest) {
            this.virtualGuests.add((VirtualGuest)Preconditions.checkNotNull((Object)virtualGuest, (Object)"virtualGuest"));
            return this;
        }

        public Builder virtualGuests(Iterable<VirtualGuest> virtualGuests) {
            this.virtualGuests = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(virtualGuests, (Object)"virtualGuests")));
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder useHourlyPricing(Boolean useHourlyPricing) {
            this.useHourlyPricing = useHourlyPricing;
            return this;
        }

        public ProductOrder build() {
            return new ProductOrder(this.packageId, this.location, this.prices, this.virtualGuests, this.quantity, this.useHourlyPricing);
        }

        public static Builder fromProductOrder(ProductOrder in) {
            return ProductOrder.builder().packageId(in.getPackageId()).location(in.getLocation()).prices(in.getPrices()).virtualGuests(in.getVirtualGuests()).quantity(in.getQuantity()).useHourlyPricing(in.getUseHourlyPricing());
        }
    }
}

