/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.ProductItem;

public class ProductPackage
implements Comparable<ProductPackage> {
    private int id = -1;
    private String name;
    private String description;
    private Set<ProductItem> items = Sets.newLinkedHashSet();
    private Set<Datacenter> locations = Sets.newLinkedHashSet();

    public static Builder builder() {
        return new Builder();
    }

    ProductPackage() {
    }

    public ProductPackage(int id, String name, String description, Iterable<ProductItem> items, Iterable<Datacenter> datacenters) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.items = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(items, (Object)"items")));
        this.locations = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(datacenters, (Object)"datacenters")));
    }

    @Override
    public int compareTo(ProductPackage arg0) {
        return new Integer(this.id).compareTo(arg0.getId());
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<ProductItem> getItems() {
        return this.items;
    }

    public Set<Datacenter> getDatacenters() {
        return this.locations;
    }

    public Builder toBuilder() {
        return Builder.fromProductPackage(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductPackage other = (ProductPackage)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "ProductPackage [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", items=" + this.items + ", datacenters=" + this.locations + "]";
    }

    public static class Builder {
        private int id = -1;
        private String name;
        private String description;
        private Set<ProductItem> items = Sets.newLinkedHashSet();
        private Set<Datacenter> datacenters = Sets.newLinkedHashSet();

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder items(Iterable<ProductItem> items) {
            this.items = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(items, (Object)"items")));
            return this;
        }

        public Builder datacenters(Iterable<Datacenter> datacenters) {
            this.datacenters = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(datacenters, (Object)"datacenters")));
            return this;
        }

        public ProductPackage build() {
            return new ProductPackage(this.id, this.name, this.description, this.items, this.datacenters);
        }

        public static Builder fromProductPackage(ProductPackage in) {
            return ProductPackage.builder().id(in.getId()).name(in.getName()).description(in.getDescription()).items(in.getItems()).datacenters(in.getDatacenters());
        }
    }
}

