/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.handlers;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;

@Singleton
public class SoftLayerErrorHandler
implements HttpErrorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var4_9;
        String message = this.parseMessage(response);
        HttpResponseException httpResponseException = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        try {
            message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
            switch (response.getStatusCode()) {
                case 401: 
                case 403: {
                    AuthorizationException authorizationException = new AuthorizationException(message, (Throwable)httpResponseException);
                    break;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
                    break;
                }
                case 500: {
                    if (message == null) break;
                    if (message.indexOf("Unable to determine package for") != -1) {
                        ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
                        break;
                    }
                    if (message.indexOf("currently an active transaction") == -1) break;
                    IllegalStateException illegalStateException = new IllegalStateException(message, (Throwable)httpResponseException);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            if (response.getPayload() != null) {
                Closeables.closeQuietly((Closeable)response.getPayload().getInput());
            }
            command.setException((Exception)httpResponseException);
            throw throwable;
        }
        if (response.getPayload() != null) {
            Closeables.closeQuietly((Closeable)response.getPayload().getInput());
        }
        command.setException((Exception)var4_9);
    }

    public String parseMessage(HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        try {
            String string = Strings2.toStringAndClose((InputStream)response.getPayload().getInput());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                response.getPayload().getInput().close();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }
}

