/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.AsyncClientFactory;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.VCloudToken;
import org.jclouds.trmk.vcloud_0_8.compute.functions.FindLocationForResource;
import org.jclouds.trmk.vcloud_0_8.config.DefaultVCloudReferencesModule;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudSession;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.endpoints.Keys;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.endpoints.OrgList;
import org.jclouds.trmk.vcloud_0_8.endpoints.VCloudLogin;
import org.jclouds.trmk.vcloud_0_8.functions.AllCatalogItemsInCatalog;
import org.jclouds.trmk.vcloud_0_8.functions.AllCatalogItemsInOrg;
import org.jclouds.trmk.vcloud_0_8.functions.AllCatalogsInOrg;
import org.jclouds.trmk.vcloud_0_8.functions.AllVDCsInOrg;
import org.jclouds.trmk.vcloud_0_8.functions.OrgsForLocations;
import org.jclouds.trmk.vcloud_0_8.functions.OrgsForNames;
import org.jclouds.trmk.vcloud_0_8.functions.VAppTemplatesForCatalogItems;
import org.jclouds.trmk.vcloud_0_8.handlers.ParseTerremarkVCloudErrorFromHttpResponse;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudLoginAsyncClient;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudVersionsAsyncClient;
import org.jclouds.trmk.vcloud_0_8.predicates.TaskSuccess;
import org.jclouds.util.Strings2;

public class TerremarkVCloudRestClientModule<S extends TerremarkVCloudClient, A extends TerremarkVCloudAsyncClient>
extends RestClientModule<S, A> {
    static final Function<ReferenceType, String> name = new Function<ReferenceType, String>(){

        public String apply(ReferenceType from) {
            return from.getName();
        }
    };

    public TerremarkVCloudRestClientModule(Class<S> syncClientType, Class<A> asyncClientType) {
        super(syncClientType, asyncClientType);
    }

    public TerremarkVCloudRestClientModule(Class<S> syncClientType, Class<A> asyncClientType, Map<Class<?>, Class<?>> delegateMap) {
        super(syncClientType, asyncClientType, delegateMap);
    }

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<Function<Iterable<? extends CatalogItem>, Iterable<? extends VAppTemplate>>>(){}).to((TypeLiteral)new TypeLiteral<VAppTemplatesForCatalogItems>(){});
        this.bind((TypeLiteral)new TypeLiteral<AtomicReference<AuthorizationException>>(){}).toInstance(new AtomicReference());
        this.installDefaultVCloudEndpointsModule();
        this.bind((TypeLiteral)new TypeLiteral<Function<ReferenceType, Location>>(){}).to((TypeLiteral)new TypeLiteral<FindLocationForResource>(){});
        this.bind((TypeLiteral)new TypeLiteral<Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends Catalog>>>(){}).to((TypeLiteral)new TypeLiteral<AllCatalogsInOrg>(){});
        this.bind((TypeLiteral)new TypeLiteral<Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends VDC>>>(){}).to((TypeLiteral)new TypeLiteral<AllVDCsInOrg>(){});
        this.bind((TypeLiteral)new TypeLiteral<Function<Iterable<String>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>>>(){}).to((TypeLiteral)new TypeLiteral<OrgsForNames>(){});
        this.bind((TypeLiteral)new TypeLiteral<Function<Iterable<? extends Location>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>>>(){}).to((TypeLiteral)new TypeLiteral<OrgsForLocations>(){});
        this.bind((TypeLiteral)new TypeLiteral<Function<Catalog, Iterable<? extends CatalogItem>>>(){}).to((TypeLiteral)new TypeLiteral<AllCatalogItemsInCatalog>(){});
        this.bind((TypeLiteral)new TypeLiteral<Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends CatalogItem>>>(){}).to((TypeLiteral)new TypeLiteral<AllCatalogItemsInOrg>(){});
    }

    @Provides
    @Singleton
    @org.jclouds.trmk.vcloud_0_8.endpoints.VDC
    protected Supplier<Map<String, String>> provideVDCtoORG(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgNameToOrgSuppier) {
        return Suppliers.compose((Function)new Function<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>, Map<String, String>>(){

            public Map<String, String> apply(Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org> arg0) {
                ImmutableMap.Builder returnVal = ImmutableMap.builder();
                for (Map.Entry<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org> orgr : arg0.entrySet()) {
                    for (String vdc : orgr.getValue().getVDCs().keySet()) {
                        returnVal.put((Object)vdc, (Object)orgr.getKey());
                    }
                }
                return returnVal.build();
            }
        }, orgNameToOrgSuppier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> provideOrgMapCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgMapSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(authException, seconds, (Supplier)supplier);
    }

    @Provides
    @Singleton
    @OrgList
    URI provideOrgListURI(Supplier<VCloudSession> sessionSupplier) {
        VCloudSession session = (VCloudSession)sessionSupplier.get();
        return URI.create(((ReferenceType)Iterables.getLast(session.getOrgs().values())).getHref().toASCIIString().replaceAll("org/.*", "org"));
    }

    protected void installDefaultVCloudEndpointsModule() {
        this.install((Module)new DefaultVCloudReferencesModule());
    }

    @VCloudToken
    @Provides
    String provideVCloudToken(Supplier<VCloudSession> cache) {
        return (String)Preconditions.checkNotNull((Object)((VCloudSession)cache.get()).getVCloudToken(), (Object)"No token present in session");
    }

    @Provides
    @Org
    @Singleton
    protected Supplier<Map<String, ReferenceType>> provideVDCtoORG(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgNameToOrgSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(authException, seconds, (Supplier)supplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<URI, ? extends VDC>> provideURIToVDC(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, URItoVDC supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(authException, seconds, (Supplier)supplier);
    }

    @Provides
    @Singleton
    @VCloudLogin
    protected URI provideAuthenticationURI(TerremarkVCloudVersionsAsyncClient versionService, @Named(value="jclouds.api-version") String version) throws InterruptedException, ExecutionException, TimeoutException {
        SortedMap versions = (SortedMap)versionService.getSupportedVersions().get(180L, TimeUnit.SECONDS);
        Preconditions.checkState((versions.size() > 0 ? 1 : 0) != 0, (Object)"No versions present");
        Preconditions.checkState((boolean)versions.containsKey(version), (Object)("version " + version + " not present in: " + versions));
        return (URI)versions.get(version);
    }

    @Provides
    @Singleton
    protected TerremarkVCloudVersionsAsyncClient provideVCloudVersions(AsyncClientFactory factory) {
        return (TerremarkVCloudVersionsAsyncClient)factory.create(TerremarkVCloudVersionsAsyncClient.class);
    }

    @Provides
    @Singleton
    protected org.jclouds.trmk.vcloud_0_8.domain.Org provideOrg(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier, @Org ReferenceType defaultOrg) {
        return (org.jclouds.trmk.vcloud_0_8.domain.Org)((Map)orgSupplier.get()).get(defaultOrg.getName());
    }

    @Provides
    @Singleton
    protected Predicate<URI> successTester(Injector injector, @Named(value="jclouds.vcloud.timeout.task-complete") long completed) {
        return new RetryablePredicate((Predicate)injector.getInstance(TaskSuccess.class), completed);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, ? extends Catalog>>> provideOrgCatalogItemMapSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgCatalogSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(authException, seconds, (Supplier)supplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, ? extends VDC>>> provideOrgVDCSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgVDCSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(authException, seconds, (Supplier)supplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, Map<String, ? extends CatalogItem>>>> provideOrgCatalogItemSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgCatalogItemSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(authException, seconds, (Supplier)supplier);
    }

    @Provides
    @Org
    Map<String, ReferenceType> listOrgs(Supplier<VCloudSession> sessionSupplier) {
        return ((VCloudSession)sessionSupplier.get()).getOrgs();
    }

    @Provides
    @Singleton
    protected TerremarkVCloudLoginAsyncClient provideVCloudLogin(AsyncClientFactory factory) {
        return (TerremarkVCloudLoginAsyncClient)factory.create(TerremarkVCloudLoginAsyncClient.class);
    }

    @Provides
    @Singleton
    protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, final TerremarkVCloudLoginAsyncClient login) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(authException, seconds, (Supplier)new Supplier<VCloudSession>(){

            public VCloudSession get() {
                try {
                    return (VCloudSession)login.login().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                    assert (false) : e;
                    return null;
                }
            }
        });
    }

    @Singleton
    @Provides
    @Named(value="CreateInternetService")
    String provideCreateInternetService() throws IOException {
        return Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateInternetService.xml"));
    }

    @Singleton
    @Provides
    @Named(value="CreateNodeService")
    String provideCreateNodeService() throws IOException {
        return Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateNodeService.xml"));
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseTerremarkVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseTerremarkVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseTerremarkVCloudErrorFromHttpResponse.class);
    }

    @Provides
    @Singleton
    @Keys
    protected Supplier<Map<String, ReferenceType>> provideOrgToKeysListCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgNameToKeysListSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(authException, seconds, (Supplier)supplier);
    }

    @Singleton
    @Provides
    @Named(value="CreateKey")
    String provideCreateKey() throws IOException {
        return Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateKey.xml"));
    }

    @Singleton
    public static class OrgNameToKeysListSupplier
    implements Supplier<Map<String, ReferenceType>> {
        protected final Supplier<VCloudSession> sessionSupplier;
        private final TerremarkVCloudClient client;

        @Inject
        protected OrgNameToKeysListSupplier(Supplier<VCloudSession> sessionSupplier, TerremarkVCloudClient client) {
            this.sessionSupplier = sessionSupplier;
            this.client = client;
        }

        public Map<String, ReferenceType> get() {
            return Maps.transformValues(((VCloudSession)this.sessionSupplier.get()).getOrgs(), (Function)new Function<ReferenceType, ReferenceType>(){

                public ReferenceType apply(ReferenceType from) {
                    return OrgNameToKeysListSupplier.this.client.findOrgNamed(from.getName()).getKeys();
                }
            });
        }
    }

    @Singleton
    public static class OrgCatalogItemSupplier
    implements Supplier<Map<String, Map<String, Map<String, ? extends CatalogItem>>>> {
        protected final Supplier<Map<String, Map<String, ? extends Catalog>>> catalogSupplier;
        protected final Function<Catalog, Iterable<? extends CatalogItem>> allCatalogItemsInCatalog;

        @Inject
        protected OrgCatalogItemSupplier(Supplier<Map<String, Map<String, ? extends Catalog>>> catalogSupplier, Function<Catalog, Iterable<? extends CatalogItem>> allCatalogItemsInCatalog) {
            this.catalogSupplier = catalogSupplier;
            this.allCatalogItemsInCatalog = allCatalogItemsInCatalog;
        }

        public Map<String, Map<String, Map<String, ? extends CatalogItem>>> get() {
            return Maps.transformValues((Map)((Map)this.catalogSupplier.get()), (Function)new Function<Map<String, ? extends Catalog>, Map<String, Map<String, ? extends CatalogItem>>>(){

                public Map<String, Map<String, ? extends CatalogItem>> apply(Map<String, ? extends Catalog> from) {
                    return Maps.transformValues(from, (Function)new Function<Catalog, Map<String, ? extends CatalogItem>>(){

                        public Map<String, ? extends CatalogItem> apply(Catalog from) {
                            return Maps.uniqueIndex((Iterable)((Iterable)OrgCatalogItemSupplier.this.allCatalogItemsInCatalog.apply((Object)from)), name);
                        }
                    });
                }
            });
        }
    }

    @Singleton
    public static class OrgVDCSupplier
    implements Supplier<Map<String, Map<String, ? extends VDC>>> {
        protected final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier;
        private final Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends VDC>> allVDCsInOrg;

        @Inject
        protected OrgVDCSupplier(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier, Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends VDC>> allVDCsInOrg) {
            this.orgSupplier = orgSupplier;
            this.allVDCsInOrg = allVDCsInOrg;
        }

        public Map<String, Map<String, ? extends VDC>> get() {
            return Maps.transformValues((Map)Maps.transformValues((Map)((Map)this.orgSupplier.get()), this.allVDCsInOrg), (Function)new Function<Iterable<? extends VDC>, Map<String, ? extends VDC>>(){

                public Map<String, ? extends VDC> apply(Iterable<? extends VDC> from) {
                    return Maps.uniqueIndex(from, name);
                }
            });
        }
    }

    @Singleton
    private static class OrgNameToOrgSupplier
    implements Supplier<Map<String, ReferenceType>> {
        private final Supplier<VCloudSession> sessionSupplier;

        @Inject
        OrgNameToOrgSupplier(Supplier<VCloudSession> sessionSupplier) {
            this.sessionSupplier = sessionSupplier;
        }

        public Map<String, ReferenceType> get() {
            return ((VCloudSession)this.sessionSupplier.get()).getOrgs();
        }
    }

    @Singleton
    public static class URItoVDC
    implements Supplier<Map<URI, ? extends VDC>> {
        private final Supplier<Map<String, Map<String, ? extends VDC>>> orgVDCMap;

        @Inject
        URItoVDC(Supplier<Map<String, Map<String, ? extends VDC>>> orgVDCMap) {
            this.orgVDCMap = orgVDCMap;
        }

        public Map<URI, ? extends VDC> get() {
            return Maps.uniqueIndex((Iterable)Iterables.concat((Iterable)Iterables.transform(((Map)this.orgVDCMap.get()).values(), (Function)new Function<Map<String, ? extends VDC>, Iterable<? extends VDC>>(){

                public Iterable<? extends VDC> apply(Map<String, ? extends VDC> from) {
                    return from.values();
                }
            })), (Function)new Function<VDC, URI>(){

                public URI apply(VDC from) {
                    return from.getHref();
                }
            });
        }
    }

    @Singleton
    public static class OrgCatalogSupplier
    implements Supplier<Map<String, Map<String, ? extends Catalog>>> {
        protected final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier;
        protected final Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends Catalog>> allCatalogsInOrg;

        @Inject
        protected OrgCatalogSupplier(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier, Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends Catalog>> allCatalogsInOrg) {
            this.orgSupplier = orgSupplier;
            this.allCatalogsInOrg = allCatalogsInOrg;
        }

        public Map<String, Map<String, ? extends Catalog>> get() {
            return Maps.transformValues((Map)Maps.transformValues((Map)((Map)this.orgSupplier.get()), this.allCatalogsInOrg), (Function)new Function<Iterable<? extends Catalog>, Map<String, ? extends Catalog>>(){

                public Map<String, ? extends Catalog> apply(Iterable<? extends Catalog> from) {
                    return Maps.uniqueIndex(from, name);
                }
            });
        }
    }

    @Singleton
    public static class OrgMapSupplier
    implements Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> {
        protected final Supplier<VCloudSession> sessionSupplier;
        protected final Function<Iterable<String>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> organizationsForNames;

        @Inject
        protected OrgMapSupplier(Supplier<VCloudSession> sessionSupplier, Function<Iterable<String>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> organizationsForNames) {
            this.sessionSupplier = sessionSupplier;
            this.organizationsForNames = organizationsForNames;
        }

        public Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org> get() {
            return Maps.uniqueIndex((Iterable)((Iterable)this.organizationsForNames.apply(((VCloudSession)this.sessionSupplier.get()).getOrgs().keySet())), name);
        }
    }
}

