/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.binder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rimuhosting.miro.binder.RimuHostingJsonBinder;
import org.jclouds.rimuhosting.miro.data.CreateOptions;
import org.jclouds.rimuhosting.miro.data.NewServerData;
import org.jclouds.rimuhosting.miro.domain.MetaData;

public class CreateServerOptions
extends RimuHostingJsonBinder {
    private String password;
    private List<MetaData> metaData = new ArrayList<MetaData>();

    @Inject
    public CreateServerOptions(Json jsonBinder) {
        super(jsonBinder);
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        String name = (String)Preconditions.checkNotNull((Object)postParams.get("name"));
        String imageId = (String)Preconditions.checkNotNull((Object)postParams.get("imageId"));
        String planId = (String)Preconditions.checkNotNull((Object)postParams.get("planId"));
        String password = this.password;
        NewServerData newServerData = new NewServerData(new CreateOptions(name, password, imageId), planId);
        newServerData.setMetaData(this.metaData);
        return this.bindToRequest(request, newServerData);
    }

    public CreateServerOptions withPassword(String password) {
        this.password = password;
        return this;
    }

    public CreateServerOptions withMetaData(List<MetaData> metaData) {
        this.metaData = metaData;
        return this;
    }
}

