/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.domain.Credentials;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.binder.CreateServerOptions;
import org.jclouds.rimuhosting.miro.domain.NewServerResponse;
import org.jclouds.rimuhosting.miro.domain.Server;

@Singleton
public class RimuHostingCreateNodeWithGroupEncodedIntoName
implements CreateNodeWithGroupEncodedIntoName {
    protected final RimuHostingClient client;
    protected final Map<String, Credentials> credentialStore;
    protected final Function<Server, NodeMetadata> serverToNodeMetadata;

    @Inject
    protected RimuHostingCreateNodeWithGroupEncodedIntoName(RimuHostingClient client, Map<String, Credentials> credentialStore, Function<Server, NodeMetadata> serverToNodeMetadata) {
        this.client = client;
        this.credentialStore = credentialStore;
        this.serverToNodeMetadata = serverToNodeMetadata;
    }

    public NodeMetadata createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        NewServerResponse serverResponse = this.client.createServer(name, (String)Preconditions.checkNotNull((Object)template.getImage().getProviderId(), (Object)"imageId"), (String)Preconditions.checkNotNull((Object)template.getHardware().getProviderId(), (Object)"hardwareId"), new CreateServerOptions[0]);
        Server from = this.client.getServer(serverResponse.getServer().getId());
        this.credentialStore.put("node#" + from.getId(), new Credentials("root", serverResponse.getNewInstanceRequest().getCreateOptions().getPassword()));
        return (NodeMetadata)this.serverToNodeMetadata.apply((Object)from);
    }
}

