/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.domain.Server;

@Singleton
public class RimuHostingListNodesStrategy
implements ListNodesStrategy {
    private final RimuHostingClient client;
    private final Function<Server, NodeMetadata> serverToNodeMetadata;

    @Inject
    protected RimuHostingListNodesStrategy(RimuHostingClient client, Function<Server, NodeMetadata> serverToNodeMetadata) {
        this.client = client;
        this.serverToNodeMetadata = serverToNodeMetadata;
    }

    public Iterable<? extends ComputeMetadata> listNodes() {
        return this.listDetailsOnNodesMatching((Predicate<ComputeMetadata>)NodePredicates.all());
    }

    public Iterable<? extends NodeMetadata> listDetailsOnNodesMatching(Predicate<ComputeMetadata> filter) {
        return Iterables.filter((Iterable)Iterables.transform(this.client.getServerList(), this.serverToNodeMetadata), filter);
    }
}

