/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.filters;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.utils.ModifyRequest;

@Singleton
public class RimuHostingAuthentication
implements HttpRequestFilter {
    private final String header;

    @Inject
    public RimuHostingAuthentication(@Named(value="jclouds.identity") String apikey) {
        this.header = String.format("rimuhosting apikey=%s", Preconditions.checkNotNull((Object)apikey, (Object)"apikey"));
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ModifyRequest.replaceHeader((HttpRequest)request, (String)"Authorization", (String[])new String[]{this.header});
    }
}

