/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rimuhosting.miro.domain.PricingPlan;
import org.jclouds.rimuhosting.miro.domain.internal.RimuHostingResponse;

@Singleton
public class ParsePricingPlansFromJsonResponse
implements Function<HttpResponse, SortedSet<PricingPlan>> {
    private final ParseJson<Map<String, PlansResponse>> json;

    @Inject
    ParsePricingPlansFromJsonResponse(ParseJson<Map<String, PlansResponse>> json) {
        this.json = json;
    }

    public SortedSet<PricingPlan> apply(HttpResponse arg0) {
        return ((PlansResponse)Iterables.get(((Map)this.json.apply(arg0)).values(), (int)0)).pricing_plan_infos;
    }

    private static class PlansResponse
    extends RimuHostingResponse {
        private SortedSet<PricingPlan> pricing_plan_infos;

        private PlansResponse() {
        }
    }
}

