/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.mail.marshaler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.xml.transform.Source;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.mail.marshaler.AbstractMailMarshaler;
import org.apache.servicemix.mail.utils.MailContentType;
import org.apache.servicemix.mail.utils.MailUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMailMarshaler
extends AbstractMailMarshaler {
    private final Logger logger = LoggerFactory.getLogger(DefaultMailMarshaler.class);

    public void convertMailToJBI(MessageExchange exchange, NormalizedMessage nmsg, MimeMessage mailMsg) throws javax.mail.MessagingException {
        MailUtils.extractHeadersFromMail(nmsg, mailMsg);
        try {
            MailUtils.extractBodyFromMail(nmsg, mailMsg);
            if (nmsg.getContent() == null) {
                nmsg.setContent((Source)new StringSource("<no-content />"));
            }
        }
        catch (Exception e) {
            nmsg.setProperty("org.apache.servicemix.mail.text", (Object)"<no-content />");
            this.logger.error("Unable to extract the mail content: {}", MailUtils.extractBodyFromMail((Message)mailMsg), (Object)e);
        }
        MailUtils.extractAttachmentsFromMail(nmsg, mailMsg);
    }

    public void convertJBIToMail(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage nmsg, String configuredSender, String configuredReceiver) throws javax.mail.MessagingException {
        try {
            this.fillMailHeaders(mimeMessage, nmsg, configuredSender, configuredReceiver);
            this.fillMailBodyAndAttachments(mimeMessage, exchange, nmsg);
        }
        catch (Exception ex) {
            throw new javax.mail.MessagingException(ex.getMessage(), ex);
        }
    }

    protected void fillMailBodyAndAttachments(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage nmsg) throws Exception {
        boolean isHtml;
        String contentType = null;
        if (nmsg.getProperty("org.apache.servicemix.mail.type") != null) {
            contentType = nmsg.getProperty("org.apache.servicemix.mail.type").toString();
        }
        boolean isText = nmsg.getProperty("org.apache.servicemix.mail.text") != null;
        boolean bl = isHtml = nmsg.getProperty("org.apache.servicemix.mail.html") != null || !isText || nmsg.getContent() != null;
        if (contentType == null) {
            if (isHtml) {
                this.prepareMixedMail(mimeMessage, exchange, nmsg);
            } else {
                this.preparePlainTextMail(mimeMessage, nmsg);
            }
        } else {
            MailContentType mct = MailContentType.getEnumForValue(contentType);
            switch (mct) {
                case TEXT_PLAIN: {
                    this.preparePlainTextMail(mimeMessage, nmsg);
                    break;
                }
                case TEXT_HTML: 
                case TEXT_XML: 
                case MULTIPART: 
                case MULTIPART_MIXED: {
                    this.prepareMixedMail(mimeMessage, exchange, nmsg);
                    break;
                }
                case MULTIPART_ALTERNATIVE: {
                    this.prepareAlternativeMail(mimeMessage, exchange, nmsg);
                    break;
                }
                default: {
                    if (isHtml && isText) {
                        this.prepareAlternativeMail(mimeMessage, exchange, nmsg);
                        break;
                    }
                    if (isText && nmsg.getAttachmentNames().size() == 0) {
                        this.preparePlainTextMail(mimeMessage, nmsg);
                        break;
                    }
                    this.prepareMixedMail(mimeMessage, exchange, nmsg);
                }
            }
        }
    }

    protected void preparePlainTextMail(MimeMessage mimeMessage, NormalizedMessage nmsg) throws Exception {
        Object content = nmsg.getProperty("org.apache.servicemix.mail.text");
        Object charset = nmsg.getProperty("org.apache.servicemix.mail.charset");
        if (content != null) {
            if (charset != null) {
                mimeMessage.setText(content.toString(), charset.toString(), "plain");
            } else {
                mimeMessage.setText(content.toString(), MimeUtility.getDefaultJavaCharset(), "plain");
            }
        } else {
            throw new MessagingException("Unable to get mail content for text/plain message from exchange.");
        }
    }

    protected void prepareMixedMail(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage nmsg) throws Exception {
        boolean isText = nmsg.getProperty("org.apache.servicemix.mail.text") != null;
        boolean isHtml = nmsg.getProperty("org.apache.servicemix.mail.html") != null;
        boolean useInline = nmsg.getProperty("org.apache.servicemix.mail.attachments.inline") != null && (Boolean)nmsg.getProperty("org.apache.servicemix.mail.attachments.inline") != false;
        Object content_text = nmsg.getProperty("org.apache.servicemix.mail.text");
        Object content_html = nmsg.getProperty("org.apache.servicemix.mail.html");
        Object charset = nmsg.getProperty("org.apache.servicemix.mail.charset");
        MimeMultipart multipart = new MimeMultipart();
        multipart.setSubType("mixed");
        if (isText && content_text != null) {
            MimeBodyPart textBodyPart = new MimeBodyPart();
            if (charset != null) {
                textBodyPart.setText(content_text.toString(), charset.toString(), "plain");
            } else {
                textBodyPart.setText(content_text.toString(), MimeUtility.getDefaultJavaCharset(), "plain");
            }
            multipart.addBodyPart((BodyPart)textBodyPart);
        }
        if (isHtml && content_html != null) {
            MimeBodyPart htmlBodyPart = new MimeBodyPart();
            htmlBodyPart.setContent((Object)content_html.toString(), MailContentType.TEXT_HTML.getMimeType());
            multipart.addBodyPart((BodyPart)htmlBodyPart);
        }
        this.appendAttachments(exchange, nmsg, multipart, useInline ? "inline" : "attachment");
        mimeMessage.setContent((Multipart)multipart);
    }

    protected void prepareAlternativeMail(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage nmsg) throws Exception {
        boolean isText = nmsg.getProperty("org.apache.servicemix.mail.text") != null;
        boolean isHtml = nmsg.getProperty("org.apache.servicemix.mail.html") != null;
        boolean useInline = true;
        if (nmsg.getProperty("org.apache.servicemix.mail.attachments.inline") != null && !((Boolean)nmsg.getProperty("org.apache.servicemix.mail.attachments.inline")).booleanValue()) {
            useInline = false;
        }
        Object content_text = nmsg.getProperty("org.apache.servicemix.mail.text");
        Object content_html = nmsg.getProperty("org.apache.servicemix.mail.html");
        Object charset = nmsg.getProperty("org.apache.servicemix.mail.charset");
        MimeMultipart multipart = new MimeMultipart();
        multipart.setSubType("alternative");
        if (isText && content_text != null) {
            MimeBodyPart textBodyPart = new MimeBodyPart();
            if (charset != null) {
                textBodyPart.setText(content_text.toString(), charset.toString(), "plain");
            } else {
                textBodyPart.setText(content_text.toString(), MimeUtility.getDefaultJavaCharset(), "plain");
            }
            multipart.addBodyPart((BodyPart)textBodyPart);
        }
        if (nmsg.getAttachmentNames().size() < 1) {
            if (isHtml && content_html != null) {
                MimeBodyPart htmlBodyPart = new MimeBodyPart();
                htmlBodyPart.setContent((Object)content_html.toString(), MailContentType.TEXT_HTML.getMimeType());
                multipart.addBodyPart((BodyPart)htmlBodyPart);
            }
        } else if (!useInline) {
            MimeBodyPart htmlpart = new MimeBodyPart();
            MimeMultipart mmp = new MimeMultipart();
            mmp.setSubType("mixed");
            if (isHtml && content_html != null) {
                MimeBodyPart htmlBodyPart = new MimeBodyPart();
                htmlBodyPart.setContent((Object)content_html.toString(), MailContentType.TEXT_HTML.getMimeType());
                mmp.addBodyPart((BodyPart)htmlBodyPart);
            }
            htmlpart.setContent((Multipart)mmp);
            multipart.addBodyPart((BodyPart)htmlpart);
            this.appendAttachments(exchange, nmsg, mmp, "attachment");
        } else {
            MimeMultipart multipartRelated = new MimeMultipart("related");
            MimeBodyPart related = new MimeBodyPart();
            related.setContent((Multipart)multipartRelated);
            multipart.addBodyPart((BodyPart)related);
            if (isHtml && content_html != null) {
                MimeBodyPart htmlBodyPart = new MimeBodyPart();
                htmlBodyPart.setContent((Object)content_html.toString(), MailContentType.TEXT_HTML.getMimeType());
                multipartRelated.addBodyPart((BodyPart)htmlBodyPart);
            }
            this.appendAttachments(exchange, nmsg, multipartRelated, "inline");
        }
        mimeMessage.setContent((Multipart)multipart);
    }

    protected void appendAttachments(MessageExchange exchange, NormalizedMessage nmsg, MimeMultipart multipart, String partType) throws Exception {
        Iterator itAttNames;
        if (nmsg.getAttachmentNames().size() > 0 && (itAttNames = nmsg.getAttachmentNames().iterator()).hasNext()) {
            while (itAttNames.hasNext()) {
                String oneAttachmentName = (String)itAttNames.next();
                DataHandler dh = nmsg.getAttachment(oneAttachmentName);
                File f = File.createTempFile("" + System.currentTimeMillis() + "-", dh.getDataSource().getName());
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                dh.writeTo((OutputStream)bos);
                bos.close();
                this.logger.debug("Saved temp file: {} with length: {}", (Object)f.getName(), (Object)f.length());
                this.addTemporaryResource(exchange.getExchangeId(), f);
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(f)));
                messageBodyPart.setFileName(dh.getDataSource().getName());
                messageBodyPart.setDisposition(partType);
                if (oneAttachmentName.toLowerCase().startsWith("cid:")) {
                    messageBodyPart.setContentID(oneAttachmentName.substring(4));
                }
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
        }
    }

    protected void fillMailHeaders(MimeMessage mimeMessage, NormalizedMessage nmsg, String configuredSender, String configuredReceiver) throws Exception {
        InternetAddress[] replyTo;
        String sentDate;
        InternetAddress from;
        InternetAddress[] bcc;
        InternetAddress[] cc;
        InternetAddress[] to;
        if (nmsg.getProperty("org.apache.servicemix.mail.to") != null) {
            to = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.to").toString());
            if (to != null) {
                mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])to);
            }
        } else if (configuredReceiver != null && (to = InternetAddress.parse((String)configuredReceiver)) != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])to);
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.cc") != null && (cc = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.cc").toString())) != null) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.bcc") != null && (bcc = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.bcc").toString())) != null) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
        if (configuredSender != null && configuredSender.trim().length() > 0) {
            from = InternetAddress.parse((String)configuredSender)[0];
            if (from != null) {
                mimeMessage.setFrom((Address)from);
            }
        } else if (nmsg.getProperty("org.apache.servicemix.mail.from") != null) {
            from = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.from").toString())[0];
            if (from != null) {
                mimeMessage.setFrom((Address)from);
            }
        } else {
            from = InternetAddress.parse((String)this.getDefaultSenderForOutgoingMails())[0];
            if (from != null) {
                mimeMessage.setFrom((Address)from);
            }
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.subject") != null) {
            String subject = nmsg.getProperty("org.apache.servicemix.mail.subject").toString();
            if (subject != null) {
                mimeMessage.setSubject(subject);
            } else {
                mimeMessage.setSubject("no subject");
            }
        } else {
            mimeMessage.setSubject("no subject");
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.sentdate") != null && (sentDate = nmsg.getProperty("org.apache.servicemix.mail.sentdate").toString()) != null) {
            try {
                mimeMessage.setSentDate(DateFormat.getInstance().parse(sentDate));
            }
            catch (ParseException ex) {
                mimeMessage.setSentDate(new Date());
            }
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.replyto") != null && (replyTo = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.replyto").toString())) != null) {
            mimeMessage.setReplyTo((Address[])replyTo);
        }
    }
}

