/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array;

import java.io.File;
import krati.array.Array;
import krati.core.array.AddressArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.basic.DynamicLongArray;
import krati.core.array.basic.IOTypeLongArray;
import krati.core.array.basic.StaticLongArray;

public class AddressArrayFactory {
    private boolean _indexesCached = true;

    public AddressArrayFactory(boolean indexesCached) {
        this.setIndexesCached(indexesCached);
    }

    public AddressArray createStaticAddressArray(File homeDir, int length, int batchSize, int numSyncBatches) throws Exception {
        AbstractRecoverableArray addrArray = this._indexesCached ? new StaticLongArray(length, batchSize, numSyncBatches, homeDir) : new IOTypeLongArray(Array.Type.STATIC, length, batchSize, numSyncBatches, homeDir);
        return addrArray;
    }

    public AddressArray createDynamicAddressArray(File homeDir, int batchSize, int numSyncBatches) throws Exception {
        return this.createDynamicAddressArray(homeDir, 65536, batchSize, numSyncBatches);
    }

    public AddressArray createDynamicAddressArray(File homeDir, int initialLength, int batchSize, int numSyncBatches) throws Exception {
        AbstractRecoverableArray addrArray = this._indexesCached ? new DynamicLongArray(batchSize, numSyncBatches, homeDir) : new IOTypeLongArray(Array.Type.DYNAMIC, initialLength, batchSize, numSyncBatches, homeDir);
        if (addrArray.length() < initialLength) {
            addrArray.expandCapacity(initialLength - 1);
        }
        return addrArray;
    }

    public final void setIndexesCached(boolean indexesCached) {
        this._indexesCached = indexesCached;
    }

    public final boolean getIndexesCached() {
        return this._indexesCached;
    }

    public final boolean isIndexesCached() {
        return this._indexesCached;
    }
}

