/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.entry;

import java.util.concurrent.ConcurrentLinkedQueue;
import krati.core.array.entry.Entry;
import krati.core.array.entry.EntryFactory;
import krati.core.array.entry.EntryValue;
import org.apache.log4j.Logger;

public class EntryPool<T extends EntryValue> {
    private static final Logger _log = Logger.getLogger(EntryPool.class);
    private int _entryServiceIdCounter = 0;
    private final int _entryCapacity;
    private final EntryFactory<T> _entryFactory;
    private final ConcurrentLinkedQueue<Entry<T>> _serviceQueue;
    private final ConcurrentLinkedQueue<Entry<T>> _recycleQueue;

    public EntryPool(EntryFactory<T> factory, int entryCapacity) {
        this._entryFactory = factory;
        this._entryCapacity = entryCapacity;
        this._serviceQueue = new ConcurrentLinkedQueue();
        this._recycleQueue = new ConcurrentLinkedQueue();
    }

    public final int getEntryCapacity() {
        return this._entryCapacity;
    }

    public final EntryFactory<T> getEntryFactory() {
        return this._entryFactory;
    }

    public boolean isServiceQueueEmpty() {
        return this._serviceQueue.isEmpty();
    }

    public boolean isRecycleQueueEmpty() {
        return this._recycleQueue.isEmpty();
    }

    public Entry<T> pollFromService() {
        return this._serviceQueue.poll();
    }

    public int getServiceQueueSize() {
        return this._serviceQueue.size();
    }

    public int getReycleQueueSize() {
        return this._recycleQueue.size();
    }

    public boolean addToServiceQueue(Entry<T> entry) {
        return this._serviceQueue.add(entry);
    }

    public boolean addToRecycleQueue(Entry<T> entry) {
        entry.clear();
        return this._recycleQueue.add(entry);
    }

    public Entry<T> next() {
        Entry<T> freeEntry = this._recycleQueue.poll();
        if (freeEntry == null) {
            freeEntry = this._entryFactory.newEntry(this._entryCapacity);
            _log.trace((Object)("Entry " + freeEntry.getId() + " created: " + freeEntry.getClass().getSimpleName()));
        }
        _log.trace((Object)("Entry " + freeEntry.getId() + " serviceId " + this._entryServiceIdCounter));
        freeEntry.setServiceId(this._entryServiceIdCounter++);
        return freeEntry;
    }

    public void clear() {
        while (!this._serviceQueue.isEmpty()) {
            Entry<T> entry = this._serviceQueue.poll();
            if (entry == null) continue;
            this.addToRecycleQueue(entry);
        }
    }
}

